/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.MekanismAPITags;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.chemical.attribute.IChemicalAttributeContainer;
import mekanism.api.text.APILang;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.TextComponentUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforge.registries.datamaps.IWithData;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class ChemicalStack
implements IHasTextComponent,
IHasTranslationKey,
IChemicalAttributeContainer<ChemicalStack>,
IWithData<Chemical> {
    private static final Consumer<String> ON_STACK_LOAD_ERROR = error -> MekanismAPI.logger.error("Tried to load invalid chemical: '{}'", error);
    public static final ChemicalStack EMPTY = new ChemicalStack(null);
    public static final Codec<Holder<Chemical>> CHEMICAL_NON_EMPTY_HOLDER_CODEC = Chemical.HOLDER_CODEC.validate(chemical -> chemical.is(MekanismAPI.EMPTY_CHEMICAL_KEY) ? DataResult.error(() -> "Chemical must not be mekanism:empty") : DataResult.success((Object)chemical));
    @Deprecated(forRemoval=true, since="10.7.11")
    public static final Codec<Chemical> CHEMICAL_NON_EMPTY_CODEC = CHEMICAL_NON_EMPTY_HOLDER_CODEC.xmap(Holder::value, Chemical::getAsHolder);
    public static final MapCodec<ChemicalStack> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CHEMICAL_NON_EMPTY_HOLDER_CODEC.fieldOf("id").forGetter(ChemicalStack::getChemicalHolder), (App)SerializerHelper.POSITIVE_LONG_CODEC.fieldOf("amount").forGetter(ChemicalStack::getAmount)).apply((Applicative)instance, ChemicalStack::new));
    public static final Codec<ChemicalStack> CODEC = MAP_CODEC.codec();
    public static final Codec<ChemicalStack> OPTIONAL_CODEC = ExtraCodecs.optionalEmptyMap(CODEC).xmap(optional -> optional.orElse(EMPTY), stack -> stack.isEmpty() ? Optional.empty() : Optional.of(stack));
    public static final Codec<ChemicalStack> LENIENT_OPTIONAL_CODEC = OPTIONAL_CODEC.promotePartial(ON_STACK_LOAD_ERROR).orElse((Object)EMPTY);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChemicalStack> OPTIONAL_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ChemicalStack>(){

        public ChemicalStack decode(RegistryFriendlyByteBuf buffer) {
            long amount = buffer.readVarLong();
            if (amount <= 0L) {
                return EMPTY;
            }
            return new ChemicalStack((Holder<Chemical>)((Holder)Chemical.HOLDER_STREAM_CODEC.decode((Object)buffer)), amount);
        }

        public void encode(RegistryFriendlyByteBuf buffer, ChemicalStack stack) {
            buffer.writeVarLong(stack.getAmount());
            if (!stack.isEmpty()) {
                Chemical.HOLDER_STREAM_CODEC.encode((Object)buffer, stack.getChemicalHolder());
            }
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, ChemicalStack> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ChemicalStack>(){

        public ChemicalStack decode(RegistryFriendlyByteBuf buffer) {
            ChemicalStack stack = (ChemicalStack)OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            if (stack.isEmpty()) {
                throw new DecoderException("Empty ChemicalStack not allowed");
            }
            return stack;
        }

        public void encode(RegistryFriendlyByteBuf buffer, ChemicalStack stack) {
            if (stack.isEmpty()) {
                throw new EncoderException("Empty ChemicalStack not allowed");
            }
            OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)stack);
        }
    };
    @Nullable
    private final Holder<Chemical> chemical;
    private long amount;

    public static Codec<ChemicalStack> fixedAmountCodec(long amount) {
        return RecordCodecBuilder.create(instance -> instance.group((App)CHEMICAL_NON_EMPTY_HOLDER_CODEC.fieldOf("id").forGetter(ChemicalStack::getChemicalHolder)).apply((Applicative)instance, holder -> new ChemicalStack((Holder<Chemical>)holder, amount)));
    }

    public ChemicalStack(Holder<Chemical> chemical, long amount) {
        Objects.requireNonNull(chemical, "Cannot create a ChemicalStack from a null chemical holder");
        if (chemical.kind() == Holder.Kind.DIRECT) {
            if (!chemical.isBound()) {
                throw new IllegalArgumentException("Cannot create a ChemicalStack from an unbound direct holder");
            }
            if ((chemical = MekanismAPI.CHEMICAL_REGISTRY.wrapAsHolder((Object)((Chemical)chemical.value()))).kind() == Holder.Kind.DIRECT) {
                throw new IllegalArgumentException("Cannot create a ChemicalStack from a direct holder for a chemical that is not yet registered");
            }
        }
        this.chemical = chemical;
        this.amount = amount;
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public ChemicalStack(Chemical chemical, long amount) {
        this(Objects.requireNonNull(chemical, "Cannot create a ChemicalStack from a null chemical").getAsHolder(), amount);
    }

    private ChemicalStack(@Nullable Void unused) {
        this.chemical = null;
    }

    public ChemicalStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new ChemicalStack(this.getChemicalHolder(), this.getAmount());
    }

    public ChemicalStack copyWithAmount(long amount) {
        if (this.isEmpty() || amount == 0L) {
            return EMPTY;
        }
        return new ChemicalStack(this.getChemicalHolder(), amount);
    }

    public ChemicalStack split(long amount) {
        long i = Math.min(amount, this.getAmount());
        ChemicalStack stack = this.copyWithAmount(i);
        this.shrink(i);
        return stack;
    }

    public ChemicalStack copyAndClear() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ChemicalStack stack = this.copy();
        this.setAmount(0L);
        return stack;
    }

    public Chemical getChemical() {
        return (Chemical)this.getChemicalHolder().value();
    }

    public Holder<Chemical> getChemicalHolder() {
        return this.isEmpty() ? MekanismAPI.EMPTY_CHEMICAL_HOLDER : this.chemical;
    }

    public boolean is(TagKey<Chemical> tag) {
        return this.getChemicalHolder().is(tag);
    }

    public boolean is(Chemical chemical) {
        return this.getChemical() == chemical;
    }

    public boolean is(Predicate<Holder<Chemical>> predicate) {
        return predicate.test(this.getChemicalHolder());
    }

    public boolean is(Holder<Chemical> holder) {
        return this.is((Chemical)holder.value());
    }

    public boolean is(HolderSet<Chemical> holderSet) {
        return holderSet.contains(this.getChemicalHolder());
    }

    public Stream<TagKey<Chemical>> getTags() {
        return this.getChemicalHolder().tags();
    }

    public Tag save(HolderLookup.Provider lookupProvider, Tag prefix) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty ChemicalStack");
        }
        return (Tag)CODEC.encode((Object)this, (DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)prefix).getOrThrow();
    }

    public Tag save(HolderLookup.Provider lookupProvider) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty ChemicalStack");
        }
        return (Tag)CODEC.encodeStart((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
    }

    public Tag saveOptional(HolderLookup.Provider lookupProvider) {
        return this.isEmpty() ? new CompoundTag() : this.save(lookupProvider);
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public ResourceLocation getTypeRegistryName() {
        ResourceKey key = this.getChemicalHolder().getKey();
        return key == null ? MekanismAPI.CHEMICAL_REGISTRY.getDefaultKey() : key.location();
    }

    public int getChemicalTint() {
        return this.getChemical().getTint();
    }

    public int getChemicalColorRepresentation() {
        return this.getChemical().getColorRepresentation();
    }

    public boolean isEmpty() {
        return this.chemical == null || this.chemical.is(MekanismAPI.EMPTY_CHEMICAL_KEY) || this.amount <= 0L;
    }

    public long getAmount() {
        return this.isEmpty() ? 0L : this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public void limitSize(long amount) {
        if (!this.isEmpty() && this.getAmount() > amount) {
            this.setAmount(amount);
        }
    }

    public void grow(long amount) {
        this.setAmount(this.amount + amount);
    }

    public void shrink(long amount) {
        this.setAmount(this.amount - amount);
    }

    @Override
    @Deprecated(forRemoval=true, since="10.7.11")
    public boolean has(Class<? extends ChemicalAttribute> type) {
        return this.getChemical().has(type);
    }

    @Override
    @Deprecated(forRemoval=true, since="10.7.11")
    public boolean hasLegacy(Class<? extends ChemicalAttribute> type) {
        return this.getChemical().hasLegacy(type);
    }

    public boolean isRadioactive() {
        return this.getChemical().isRadioactive();
    }

    public double getRadioactivity() {
        return this.getChemical().getRadioactivity() * (double)this.getAmount();
    }

    @Override
    @Deprecated(forRemoval=true, since="10.7.11")
    @Nullable
    public <ATTRIBUTE extends ChemicalAttribute> ATTRIBUTE get(Class<ATTRIBUTE> type) {
        return this.getChemical().get(type);
    }

    @Override
    @Deprecated(forRemoval=true, since="10.7.11")
    @Nullable
    public <ATTRIBUTE extends ChemicalAttribute> ATTRIBUTE getLegacy(Class<ATTRIBUTE> type) {
        return this.getChemical().getLegacy(type);
    }

    @Override
    @Deprecated(forRemoval=true, since="10.7.11")
    public Collection<ChemicalAttribute> getAttributes() {
        return this.getChemical().getAttributes();
    }

    @Override
    @Deprecated(forRemoval=true, since="10.7.11")
    public Collection<Class<? extends ChemicalAttribute>> getAttributeTypes() {
        return this.getChemical().getAttributeTypes();
    }

    public void appendHoverText(Item.TooltipContext context, List<Component> tooltips, TooltipFlag tooltipFlag) {
        Holder<Chemical> chemicalHolder = this.getChemicalHolder();
        if (chemicalHolder.is(MekanismAPI.EMPTY_CHEMICAL_KEY)) {
            return;
        }
        ((Chemical)chemicalHolder.value()).appendHoverText(this, context, tooltips, tooltipFlag);
        if (chemicalHolder.is(MekanismAPITags.Chemicals.WASTE_BARREL_DECAY_BLACKLIST)) {
            tooltips.add((Component)APILang.DECAY_IMMUNE.translateColored(EnumColor.AQUA));
        }
        if (tooltipFlag.isAdvanced()) {
            tooltips.add((Component)TextComponentUtil.build(ChatFormatting.DARK_GRAY, this.getChemicalHolder().getRegisteredName()));
        }
    }

    @Nullable
    public <T> T getData(DataMapType<Chemical, T> type) {
        return (T)this.getChemicalHolder().getData(type);
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        int hash = this.chemical.hashCode();
        return 31 * hash + Long.hashCode(this.amount);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChemicalStack other = (ChemicalStack)o;
        return this.getAmount() == other.getAmount() && this.is(other.getChemicalHolder());
    }

    public String toString() {
        return this.getAmount() + " " + this.getChemicalHolder().getRegisteredName();
    }

    @Override
    public Component getTextComponent() {
        return this.getChemical().getTextComponent();
    }

    @Override
    public String getTranslationKey() {
        return this.getChemical().getTranslationKey();
    }

    public static boolean isSameChemical(ChemicalStack first, ChemicalStack second) {
        return first.is(second.getChemicalHolder());
    }

    public static Optional<ChemicalStack> parse(HolderLookup.Provider lookupProvider, Tag tag) {
        return CODEC.parse((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(ON_STACK_LOAD_ERROR);
    }

    public static ChemicalStack parseOptional(HolderLookup.Provider lookupProvider, CompoundTag tag) {
        return tag.isEmpty() ? EMPTY : ChemicalStack.parse(lookupProvider, (Tag)tag).orElse(EMPTY);
    }
}

