/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.cullleaves.neoforge;

import eu.midnightdust.cullleaves.CullLeavesClient;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforgespi.locating.IModFile;

@EventBusSubscriber(modid="cullleaves", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class CullLeavesClientEvents {
    @SubscribeEvent
    public static void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            CullLeavesClientEvents.registerResourcePack(event, ResourceLocation.fromNamespaceAndPath((String)"cullleaves", (String)"smartleaves"), false);
        }
    }

    private static void registerResourcePack(AddPackFindersEvent event, ResourceLocation id, boolean alwaysEnabled) {
        event.addRepositorySource(profileAdder -> {
            IModFile file = ModList.get().getModFileById(id.getNamespace()).getFile();
            try {
                PathPackResources.PathResourcesSupplier pack = new PathPackResources.PathResourcesSupplier(file.findResource(new String[]{"resourcepacks/" + id.getPath()}));
                PackLocationInfo info = new PackLocationInfo(id.toString(), Component.nullToEmpty((String)(id.getNamespace() + "/" + id.getPath())), PackSource.BUILT_IN, Optional.empty());
                Pack packProfile = Pack.readMetaAndCreate((PackLocationInfo)info, (Pack.ResourcesSupplier)pack, (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(alwaysEnabled, Pack.Position.TOP, false));
                if (packProfile != null) {
                    profileAdder.accept(packProfile);
                }
            }
            catch (NullPointerException e) {
                e.fillInStackTrace();
            }
        });
    }

    @SubscribeEvent
    public static void onResourceReload(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)CullLeavesClient.ReloadListener.INSTANCE);
    }
}

