/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.worldgen.context;

import java.lang.ref.WeakReference;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.Nullable;

public class CavegenContext {
    private static final ThreadLocal<CavegenContext> CONTEXT = new ThreadLocal();
    private final WeakReference<ServerLevel> serverLevel;

    public CavegenContext(ServerLevel serverLevel) {
        this.serverLevel = new WeakReference<ServerLevel>(serverLevel);
    }

    public ServerLevel getServerLevel() {
        return (ServerLevel)this.serverLevel.get();
    }

    @Nullable
    public static CavegenContext pop() {
        CavegenContext context = CONTEXT.get();
        CONTEXT.remove();
        return context;
    }

    @Nullable
    public static CavegenContext peek() {
        return CONTEXT.get();
    }

    public static void push(ServerLevel world) {
        CONTEXT.set(new CavegenContext(world));
    }
}

