/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.worldgen.carver;

import com.google.common.collect.ImmutableSet;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseGen;
import com.yungnickyoung.minecraft.bettercaves.worldgen.BetterCavesWorldCarverConfig;
import com.yungnickyoung.minecraft.bettercaves.worldgen.carver.CarverSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;

public abstract class AbstractCarver {
    protected final CarverSettings settings;
    private final ImmutableSet<BlockState> DEBUG_BLOCKS = ImmutableSet.of((Object)Blocks.GOLD_BLOCK.defaultBlockState(), (Object)Blocks.OAK_PLANKS.defaultBlockState(), (Object)Blocks.COBBLESTONE.defaultBlockState(), (Object)Blocks.REDSTONE_BLOCK.defaultBlockState(), (Object)Blocks.EMERALD_BLOCK.defaultBlockState(), (Object)Blocks.BRICKS.defaultBlockState(), (Object[])new BlockState[0]);

    public abstract int getSpawnWeight();

    public abstract int getBottomY();

    public abstract int getTopY();

    public abstract NoiseGen getNoiseGen();

    public AbstractCarver(CarverSettings settings) {
        this.settings = settings;
    }

    protected void carveBlock(BetterCavesWorldCarverConfig config, ChunkAccess chunkAccess, BlockPos blockPos, BlockState airBlockState, BlockState liquidBlockState, CarvingMask carvingMask, Aquifer aquifer) {
        carvingMask.set(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        if (!chunkAccess.getBlockState(blockPos).is(config.misc.replaceable())) {
            return;
        }
        if (airBlockState.isAir() && blockPos.getY() <= this.settings.getLiquidAltitude()) {
            if (liquidBlockState != null) {
                chunkAccess.setBlockState(blockPos, liquidBlockState, false);
            }
        } else {
            BlockState newBlockState = aquifer.computeSubstance((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(blockPos.getX(), blockPos.getY(), blockPos.getZ()), 0.0);
            if (newBlockState == null) {
                return;
            }
            chunkAccess.setBlockState(blockPos, newBlockState, false);
            if (aquifer.shouldScheduleFluidUpdate() && !newBlockState.getFluidState().isEmpty()) {
                chunkAccess.markPosForPostprocessing(blockPos);
            }
        }
    }

    protected void carveBlock(BetterCavesWorldCarverConfig config, ChunkAccess chunkAccess, BlockPos blockPos, BlockState liquidBlockState, CarvingMask carvingMask, Aquifer aquifer) {
        this.carveBlock(config, chunkAccess, blockPos, Blocks.AIR.defaultBlockState(), liquidBlockState, carvingMask, aquifer);
    }

    protected void debugCarveBlock(ChunkAccess chunkIn, BlockPos blockPos, boolean digBlock) {
        if (this.DEBUG_BLOCKS.contains((Object)chunkIn.getBlockState(blockPos))) {
            return;
        }
        if (digBlock) {
            chunkIn.setBlockState(blockPos, this.settings.getDebugBlock(), false);
        } else {
            chunkIn.setBlockState(blockPos, Blocks.AIR.defaultBlockState(), false);
        }
    }
}

