/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.mixin;

import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.crafter.MechanicalCraftingRecipe;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelScreen;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.platform.CatnipServices;
import net.liukrast.eg.EGConstants;
import net.liukrast.eg.api.util.IFPExtra;
import net.liukrast.eg.networking.FactoryPanelChangeSizePacket;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FactoryPanelScreen.class})
public abstract class FactoryPanelScreenMixin
extends AbstractSimiScreen {
    @Unique
    private static final ResourceLocation extra_gauges$TEXTURE = EGConstants.id("textures/gui/auto_crafting_gauge.png", new Object[0]);
    @Unique
    private MechanicalCraftingRecipe extra_gauges$availableMechanicalRecipe = null;
    @Shadow
    private CraftingRecipe availableCraftingRecipe;
    @Shadow
    private List<BigItemStack> inputConfig;
    @Shadow
    private boolean craftingActive;
    @Shadow
    private BigItemStack outputConfig;
    @Unique
    private int extra_gauges$width = 3;
    @Unique
    private int extra_gauges$height = 3;

    @Shadow
    protected abstract void updateConfigs();

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Ljava/util/List;isEmpty()Z")})
    private void init(FactoryPanelBehaviour behaviour, CallbackInfo ci) {
        IFPExtra extra = (IFPExtra)behaviour;
        this.extra_gauges$width = extra.extra_gauges$getWidth();
    }

    @Inject(method={"searchForCraftingRecipe"}, at={@At(value="TAIL")})
    private void searchForCraftingRecipe(CallbackInfo ci, @Local ItemStack output, @Local Set<Item> itemsToUse, @Local ClientLevel level) {
        if (this.availableCraftingRecipe != null) {
            return;
        }
        this.extra_gauges$availableMechanicalRecipe = level.getRecipeManager().getAllRecipesFor(AllRecipeTypes.MECHANICAL_CRAFTING.getType()).parallelStream().filter(r -> output.getItem() == ((MechanicalCraftingRecipe)r.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).getItem()).filter(r -> {
            if (AllRecipeTypes.shouldIgnoreInAutomation((RecipeHolder)r)) {
                return false;
            }
            HashSet<Item> itemsUsed = new HashSet<Item>();
            for (Ingredient ingredient : ((MechanicalCraftingRecipe)r.value()).getIngredients()) {
                if (ingredient.isEmpty()) continue;
                boolean available = false;
                for (BigItemStack bis : this.inputConfig) {
                    if (bis.stack.isEmpty() || !ingredient.test(bis.stack)) continue;
                    available = true;
                    itemsUsed.add(bis.stack.getItem());
                    break;
                }
                if (available) continue;
                return false;
            }
            return itemsUsed.size() >= itemsToUse.size();
        }).findAny().map(RecipeHolder::value).orElse(null);
    }

    @ModifyExpressionValue(method={"init"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definition(id="availableCraftingRecipe", field={"Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelScreen;availableCraftingRecipe:Lnet/minecraft/world/item/crafting/CraftingRecipe;"})
    @Expression(value={"this.availableCraftingRecipe != null"})
    private boolean init(boolean original) {
        return original || this.extra_gauges$availableMechanicalRecipe != null;
    }

    @WrapOperation(method={"lambda$init$5"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/crafting/CraftingRecipe;getResultItem(Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;")})
    private ItemStack lambda$init$5(CraftingRecipe instance, HolderLookup.Provider provider, Operation<ItemStack> original) {
        if (this.extra_gauges$availableMechanicalRecipe != null) {
            return this.extra_gauges$availableMechanicalRecipe.getResultItem(provider);
        }
        return (ItemStack)original.call(new Object[]{instance, provider});
    }

    @ModifyExpressionValue(method={"updateConfigs"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definition(id="availableCraftingRecipe", field={"Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelScreen;availableCraftingRecipe:Lnet/minecraft/world/item/crafting/CraftingRecipe;"})
    @Expression(value={"this.availableCraftingRecipe == null"})
    private boolean updateConfigs(boolean original) {
        return original && this.extra_gauges$availableMechanicalRecipe == null;
    }

    @WrapOperation(method={"updateConfigs"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelScreen;convertRecipeToPackageOrderContext(Lnet/minecraft/world/item/crafting/CraftingRecipe;Ljava/util/List;Z)Ljava/util/List;")})
    private List<BigItemStack> updateConfigs(CraftingRecipe shaped, List<BigItemStack> i, boolean bigItemStack, Operation<List<BigItemStack>> original) {
        List list;
        if (this.extra_gauges$availableMechanicalRecipe != null) {
            if (this.extra_gauges$width < this.extra_gauges$availableMechanicalRecipe.getWidth()) {
                this.extra_gauges$width = this.extra_gauges$availableMechanicalRecipe.getWidth();
            }
            if (this.extra_gauges$height < this.extra_gauges$availableMechanicalRecipe.getHeight()) {
                this.extra_gauges$height = this.extra_gauges$availableMechanicalRecipe.getHeight();
            }
            list = FactoryPanelScreenMixin.extra_gauges$convertMechanicalToPackageOrderContext(this.extra_gauges$availableMechanicalRecipe, i, bigItemStack);
        } else {
            list = (List)original.call(new Object[]{shaped, i, bigItemStack});
        }
        BigItemStack emptyIngredient = new BigItemStack(ItemStack.EMPTY, 0);
        int k = 0;
        ImmutableList.Builder finalList = ImmutableList.builder();
        int w = this.extra_gauges$availableMechanicalRecipe != null ? this.extra_gauges$availableMechanicalRecipe.getWidth() : 3;
        int h = this.extra_gauges$availableMechanicalRecipe != null ? this.extra_gauges$availableMechanicalRecipe.getHeight() : 3;
        for (BigItemStack stack : list) {
            finalList.add((Object)stack);
            if (++k % w != 0) continue;
            for (int x = 0; x < this.extra_gauges$width - w; ++x) {
                finalList.add((Object)emptyIngredient);
            }
        }
        for (int x = 0; x < this.extra_gauges$height - h; ++x) {
            finalList.add((Object)emptyIngredient);
        }
        return finalList.build();
    }

    @Unique
    private static List<BigItemStack> extra_gauges$convertMechanicalToPackageOrderContext(MechanicalCraftingRecipe recipe, List<BigItemStack> inputs, boolean respectAmounts) {
        int i;
        ArrayList<BigItemStack> craftingIngredients = new ArrayList<BigItemStack>();
        BigItemStack emptyIngredient = new BigItemStack(ItemStack.EMPTY, 1);
        NonNullList ingredients = recipe.getIngredients();
        List mutableInputs = BigItemStack.duplicateWrappers(inputs);
        int width = recipe.getWidth();
        int height = recipe.getHeight();
        if (height == 1) {
            for (i = 0; i < 3; ++i) {
                craftingIngredients.add(emptyIngredient);
            }
        }
        if (width == 1) {
            craftingIngredients.add(emptyIngredient);
        }
        for (i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            BigItemStack craftingIngredient = emptyIngredient;
            if (!ingredient.isEmpty()) {
                for (BigItemStack bigItemStack : mutableInputs) {
                    if (bigItemStack.count <= 0 || !ingredient.test(bigItemStack.stack)) continue;
                    craftingIngredient = new BigItemStack(bigItemStack.stack, 1);
                    if (!respectAmounts) break;
                    --bigItemStack.count;
                    break;
                }
            }
            craftingIngredients.add(craftingIngredient);
            if (width >= 3 || (i + 1) % width != 0) continue;
            for (int j = 0; j < 3 - width; ++j) {
                if (craftingIngredients.size() >= 9) continue;
                craftingIngredients.add(emptyIngredient);
            }
        }
        while (craftingIngredients.size() < 9) {
            craftingIngredients.add(emptyIngredient);
        }
        return craftingIngredients;
    }

    @Inject(method={"renderWindow"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definition(id="slot", local={@Local(type=int.class, ordinal=4)})
    @Expression(value={"slot = 0"})
    private void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, CallbackInfo ci, @Local(ordinal=2) int x, @Local(ordinal=3) int y) {
        if (!this.craftingActive) {
            return;
        }
        if (this.extra_gauges$availableMechanicalRecipe != null) {
            graphics.blit(extra_gauges$TEXTURE, x + 56, y + 23, 0, 0, 79, 72);
            if (mouseX >= x + 56 + 11 && mouseX <= x + 56 + 68 && mouseY >= y + 23 + 4 && mouseY <= y + 23 + 61) {
                graphics.renderComponentTooltip(this.font, List.of(Component.translatable((String)"extra_gauges.gui.factory_panel.auto_crafting_input").withStyle(style -> style.withColor(-1123720)), CreateLang.translate((String)"gui.factory_panel.crafting_input_tip", (Object[])new Object[0]).style(ChatFormatting.GRAY).component(), Component.translatable((String)"extra_gauges.gui.factory_panel.crafting_input_tip_1", (Object[])new Object[]{this.extra_gauges$width}).withStyle(ChatFormatting.GRAY), Component.translatable((String)"extra_gauges.gui.factory_panel.crafting_input_tip_2", (Object[])new Object[]{this.extra_gauges$height}).withStyle(ChatFormatting.GRAY)), mouseX, mouseY);
            }
        }
        this.extra_gauges$generateButton(graphics, x + 56 + 75, y + 23 + 14, 80, mouseX, mouseY, (Component)Component.translatable((String)"extra_gauges.gui.factory_panel.extend_width", (Object[])new Object[]{this.extra_gauges$width}));
        if (this.extra_gauges$width > (this.extra_gauges$availableMechanicalRecipe == null ? 3 : this.extra_gauges$availableMechanicalRecipe.getWidth())) {
            this.extra_gauges$generateButton(graphics, x + 56 + 75, y + 23 + 14 + 22, 88, mouseX, mouseY, (Component)Component.translatable((String)"extra_gauges.gui.factory_panel.reduce_width", (Object[])new Object[]{this.extra_gauges$width}));
        }
    }

    @ModifyExpressionValue(method={"renderWindow"}, at={@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelScreen;craftingIngredients:Ljava/util/List;")})
    private List<BigItemStack> renderWindow(List<BigItemStack> original) {
        if (this.extra_gauges$width == 0) {
            return original;
        }
        int k = 0;
        ArrayList<BigItemStack> out = new ArrayList<BigItemStack>();
        for (BigItemStack v : original) {
            if (k % this.extra_gauges$width < 3) {
                out.add(v);
            }
            ++k;
        }
        return out;
    }

    @WrapWithCondition(method={"renderWindow"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelScreen;renderInputItem(Lnet/minecraft/client/gui/GuiGraphics;ILcom/simibubi/create/content/logistics/BigItemStack;II)V", ordinal=0)})
    private boolean renderWindow(FactoryPanelScreen instance, GuiGraphics graphics, int slot, BigItemStack itemStack, int mouseX, int mouseY, @Local(ordinal=4) LocalIntRef slotRef) {
        return this.extra_gauges$availableMechanicalRecipe == null;
    }

    @Unique
    private void extra_gauges$generateButton(GuiGraphics guiGraphics, int x, int y, int tx, int mouseX, int mouseY, Component tooltip) {
        boolean hovered = mouseX > x && mouseX < x + 8 && mouseY > y && mouseY < y + 16;
        guiGraphics.blit(extra_gauges$TEXTURE, x, y, tx, hovered ? 16 : 0, 8, 16);
        if (hovered) {
            guiGraphics.renderTooltip(this.font, tooltip, mouseX, mouseY);
        }
    }

    @ModifyExpressionValue(method={"renderInputItem"}, at={@At(value="INVOKE", target="Lnet/createmod/catnip/lang/LangBuilder;component()Lnet/minecraft/network/chat/MutableComponent;", ordinal=2)})
    private MutableComponent renderInputItem(MutableComponent original) {
        return Component.translatable((String)"extra_gauges.gui.factory_panel.crafting_input_tip_1", (Object[])new Object[]{this.extra_gauges$width}).withStyle(ChatFormatting.GRAY);
    }

    @ModifyExpressionValue(method={"renderInputItem"}, at={@At(value="INVOKE", target="Ljava/util/List;of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", ordinal=0)})
    private List<MutableComponent> renderInputItem(List<MutableComponent> original) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(original);
        builder.add((Object)Component.translatable((String)"extra_gauges.gui.factory_panel.crafting_input_tip_2", (Object[])new Object[]{this.extra_gauges$height}).withStyle(ChatFormatting.GRAY));
        return builder.build();
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void mouseClicked(double mouseX, double mouseY, int pButton, CallbackInfoReturnable<Boolean> cir) {
        if (!this.craftingActive) {
            return;
        }
        if (mouseX > (double)(this.guiLeft + 56 + 75) && mouseX < (double)(this.guiLeft + 56 + 75 + 8) && mouseY > (double)(this.guiTop + 23 + 14) && mouseY < (double)(this.guiTop + 23 + 14 + 16)) {
            ++this.extra_gauges$width;
            this.updateConfigs();
            assert (this.minecraft != null);
            assert (this.minecraft.level != null);
            this.outputConfig.count = (this.availableCraftingRecipe == null ? this.extra_gauges$availableMechanicalRecipe : this.availableCraftingRecipe).getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess()).getCount();
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
        if (this.extra_gauges$width > (this.extra_gauges$availableMechanicalRecipe == null ? 3 : this.extra_gauges$availableMechanicalRecipe.getWidth()) && mouseX > (double)(this.guiLeft + 56 + 75) && mouseX < (double)(this.guiLeft + 56 + 75 + 8) && mouseY > (double)(this.guiTop + 23 + 14 + 22) && mouseY < (double)(this.guiTop + 23 + 14 + 22 + 16)) {
            --this.extra_gauges$width;
            this.updateConfigs();
            assert (this.minecraft != null);
            assert (this.minecraft.level != null);
            this.outputConfig.count = (this.availableCraftingRecipe == null ? this.extra_gauges$availableMechanicalRecipe : this.availableCraftingRecipe).getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess()).getCount();
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Inject(method={"sendIt"}, at={@At(value="TAIL")})
    private void sendIt(FactoryPanelPosition toRemove, boolean clearPromises, CallbackInfo ci, @Local(ordinal=1) FactoryPanelPosition pos) {
        FactoryPanelChangeSizePacket packet = new FactoryPanelChangeSizePacket(pos, this.extra_gauges$width);
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)packet);
    }
}

