/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.core.travel;

import com.pedrorok.hypertube.core.connection.interfaces.ITubeActionPoint;
import com.pedrorok.hypertube.network.packets.EntityTravelDirDataPacket;
import com.pedrorok.hypertube.network.packets.SyncEntityPosPacket;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class TravelPathMover {
    private final List<Vec3> pathPoints;
    private final Set<BlockPos> actionPoints;
    private final Set<BlockPos> activeActionPoints;
    private float travelSpeed;
    private final BiConsumer<LivingEntity, Boolean> onFinishCallback;
    private final BlockPos lastPos;
    private int currentSegment = 0;
    private Vec3 currentStart;
    private Vec3 currentEnd;
    private double totalDistance;
    private double traveled;
    private boolean finished = false;
    private Vec3 lastDirection;

    public TravelPathMover(Vec3 entityPos, List<Vec3> points, Set<BlockPos> actionPoints, float travelSpeed, Vec3 lastDirection, BlockPos lastPos, BiConsumer<LivingEntity, Boolean> onFinishCallback) {
        this.pathPoints = points;
        this.actionPoints = actionPoints;
        this.activeActionPoints = new HashSet<BlockPos>();
        this.travelSpeed = travelSpeed;
        this.lastPos = lastPos;
        this.currentStart = entityPos;
        this.currentEnd = this.pathPoints.getFirst().subtract(0.0, 0.25, 0.0);
        this.totalDistance = this.currentStart.distanceTo(this.currentEnd);
        this.traveled = 0.0;
        this.onFinishCallback = onFinishCallback;
        this.lastDirection = lastDirection;
        if (lastDirection != null) {
            return;
        }
        this.lastDirection = this.pathPoints.getLast().subtract(this.pathPoints.get(this.pathPoints.size() - 2)).normalize();
    }

    public void tickEntity(LivingEntity entity) {
        if (entity.isSpectator() || !entity.isAlive()) {
            this.onFinishCallback.accept(entity, true);
            return;
        }
        if (this.traveled >= this.totalDistance) {
            ++this.currentSegment;
            if (this.currentSegment >= this.pathPoints.size() || this.finished) {
                this.onFinishCallback.accept(entity, false);
                return;
            }
            this.currentStart = this.currentEnd;
            this.currentEnd = this.pathPoints.get(this.currentSegment).subtract(0.0, 0.25, 0.0);
            this.totalDistance = this.currentStart.distanceTo(this.currentEnd);
            this.traveled = 0.0;
        }
        if (!this.activeActionPoints.isEmpty()) {
            BlockPos actionPos = this.activeActionPoints.iterator().next();
            this.activeActionPoints.remove(actionPos);
            Block block = entity.level().getBlockState(actionPos).getBlock();
            if (block instanceof ITubeActionPoint) {
                ITubeActionPoint travelAction = (ITubeActionPoint)block;
                travelAction.handleTravelPath(entity, this, actionPos);
            }
        }
        Vec3 direction = this.currentEnd.subtract(this.currentStart).normalize().scale((double)this.travelSpeed);
        Vec3 newPos = entity.position().add(direction);
        entity.moveTo(newPos.x, newPos.y, newPos.z);
        this.traveled += (double)this.travelSpeed;
        entity.resetFallDistance();
        TravelPathMover.handleEntityDirection(entity, direction);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.isFallFlying()) {
                player.stopFallFlying();
            }
            return;
        }
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)SyncEntityPosPacket.create((Entity)entity, this.currentSegment), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void handleActionPoint(BlockPos actionPos) {
        this.activeActionPoints.add(actionPos);
        this.actionPoints.remove(actionPos);
    }

    private static void handleEntityDirection(LivingEntity entity, Vec3 direction) {
        float yaw = (float)Math.toDegrees(Math.atan2(-direction.x, direction.z));
        float pitch = (float)Math.toDegrees(Math.atan2(-direction.y, Math.sqrt(direction.x * direction.x + direction.z * direction.z)));
        entity.setYRot(yaw);
        entity.setXRot(pitch);
        if (entity.level().isClientSide) {
            return;
        }
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)EntityTravelDirDataPacket.create((Entity)entity), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public Vec3 getLastDir() {
        return this.lastDirection;
    }

    public void setClientFinish() {
        this.finished = true;
    }

    public float getTravelSpeed() {
        return this.travelSpeed;
    }

    public void setTravelSpeed(float travelSpeed) {
        this.travelSpeed = travelSpeed;
    }

    public BlockPos getLastPos() {
        return this.lastPos;
    }
}

