/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.core.placement;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pedrorok.hypertube.blocks.HypertubeBlock;
import com.pedrorok.hypertube.core.connection.BezierConnection;
import com.pedrorok.hypertube.core.connection.SimpleConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnectionEntity;
import com.pedrorok.hypertube.core.placement.ResponseDTO;
import com.pedrorok.hypertube.items.HypertubeItem;
import com.pedrorok.hypertube.registry.ModBlocks;
import com.pedrorok.hypertube.registry.ModDataComponent;
import com.pedrorok.hypertube.utils.MessageUtils;
import com.pedrorok.hypertube.utils.RayCastUtils;
import com.pedrorok.hypertube.utils.TubeUtils;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class TubePlacement {
    static BlockPos hoveringPos;
    static boolean canPlace;
    static LerpedFloat animation;

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick() {
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack stack = player.getMainHandItem();
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (hitResult == null) {
            return;
        }
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        Item tubeItem = ModBlocks.HYPERTUBE.asItem();
        if (!stack.getItem().equals(tubeItem) && !(stack = player.getOffhandItem()).getItem().equals(tubeItem)) {
            return;
        }
        if (!stack.hasFoil()) {
            return;
        }
        Level level = player.level();
        BlockHitResult bhr = (BlockHitResult)hitResult;
        BlockPos pos = bhr.getBlockPos();
        BlockState hitState = level.getBlockState(pos);
        boolean hypertubeHitResult = hitState.getBlock() instanceof ITubeConnection;
        if (hitState.isAir() || hypertubeHitResult) {
            hoveringPos = pos;
        } else {
            pos = pos.relative(bhr.getDirection());
        }
        SimpleConnection connectionFrom = (SimpleConnection)stack.get(ModDataComponent.TUBE_CONNECTING_FROM);
        animation.setValue(0.8);
        if (connectionFrom == null) {
            animation.setValue(0.0);
            return;
        }
        Direction finalDirection = RayCastUtils.getDirectionFromHitResult((Player)player, () -> hypertubeHitResult);
        SimpleConnection connectionTo = new SimpleConnection(pos, finalDirection);
        BezierConnection bezierConnection = BezierConnection.of(connectionFrom, connectionTo);
        ResponseDTO response = bezierConnection.getValidation();
        if (response.valid()) {
            response = TubeUtils.checkSurvivalItems((Player)player, (int)bezierConnection.distance(), true);
        }
        if (response.valid()) {
            response = TubeUtils.checkBlockCollision(level, bezierConnection);
        }
        if (response.valid() && hypertubeHitResult) {
            response = TubeUtils.checkClickedHypertube(level, pos, finalDirection.getOpposite());
        }
        animation.setValue(!response.valid() ? 0.2 : 0.8);
        canPlace = response.valid();
        bezierConnection.drawPath(animation, canPlace);
        if (!response.valid()) {
            MessageUtils.sendActionMessage((Player)player, (Component)response.getMessageComponent());
            return;
        }
        MessageUtils.sendActionMessage((Player)player, "");
    }

    public static boolean handleHypertubeClicked(ITubeConnectionEntity tubeEntity, Player player, SimpleConnection simpleConnection, BlockPos pos, Direction direction, Level level, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(simpleConnection.pos());
        if (!(blockEntity instanceof ITubeConnectionEntity)) {
            MessageUtils.sendActionMessage(player, (Component)Component.translatable((String)"placement.create_hypertube.no_other_tube_found").withColor(0xFF0000));
            return false;
        }
        ITubeConnectionEntity otherConnection = (ITubeConnectionEntity)blockEntity;
        if (!otherConnection.hasConnectionAvailable() || !tubeEntity.hasConnectionAvailable()) {
            MessageUtils.sendActionMessage(player, (Component)Component.translatable((String)"placement.create_hypertube.cant_conn_tubes").withColor(0xFF0000));
            return false;
        }
        BezierConnection connection = new BezierConnection(simpleConnection, new SimpleConnection(pos, direction.getOpposite()));
        ResponseDTO validation = connection.getValidation();
        if (validation.valid()) {
            validation = TubeUtils.checkSurvivalItems(player, (int)connection.distance(), true);
        }
        if (validation.valid()) {
            validation = TubeUtils.checkBlockCollision(level, connection);
        }
        if (validation.valid()) {
            validation = TubeUtils.checkClickedHypertube(level, pos, direction);
        }
        if (!validation.valid()) {
            MessageUtils.sendActionMessage(player, (Component)validation.getMessageComponent().withColor(0xFF0000), true);
            return false;
        }
        TubeUtils.checkSurvivalItems(player, (int)connection.distance(), false);
        if (level.isClientSide) {
            connection.drawPath(LerpedFloat.linear().startWithValue(0.0), true);
        }
        tubeEntity.setConnection(connection.getFromPos(), direction);
        otherConnection.setConnection(connection, connection.getFromPos().direction());
        MessageUtils.sendActionMessage(player, (Component)Component.translatable((String)"placement.create_hypertube.success_conn").withColor(65280), true);
        player.playSound(SoundEvents.ITEM_FRAME_ADD_ITEM, 1.0f, 1.0f);
        HypertubeItem.clearConnection(player.getItemInHand(InteractionHand.MAIN_HAND));
        return true;
    }

    public static void tickPlayerServer(@NotNull Player player) {
        if (player.tickCount % 20 != 0) {
            return;
        }
        ItemStack itemInHand = player.getItemInHand(InteractionHand.MAIN_HAND);
        Level level = player.level();
        if (!(itemInHand.getItem() instanceof HypertubeItem)) {
            return;
        }
        if (!itemInHand.hasFoil()) {
            return;
        }
        SimpleConnection connection = (SimpleConnection)itemInHand.get(ModDataComponent.TUBE_CONNECTING_FROM);
        if (connection == null) {
            return;
        }
        if (!(level.getBlockEntity(new BlockPos((Vec3i)connection.pos())) instanceof ITubeConnectionEntity)) {
            HypertubeItem.clearConnection(itemInHand);
            MessageUtils.sendActionMessage(player, (Component)Component.translatable((String)"placement.create_hypertube.conn_cleared_invalid_block").withColor(0xFF0000));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawCustomBlockSelection(PoseStack ms, MultiBufferSource buffer, Vec3 camera) {
        ItemStack mainHandItem = Minecraft.getInstance().player.getMainHandItem();
        if (!mainHandItem.is(ModBlocks.HYPERTUBE.asItem())) {
            return;
        }
        if (!mainHandItem.hasFoil()) {
            return;
        }
        SimpleConnection connection = (SimpleConnection)mainHandItem.get(ModDataComponent.TUBE_CONNECTING_FROM);
        if (connection == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        BlockState blockState = mc.level.getBlockState(connection.pos());
        if (!(blockState.getBlock() instanceof HypertubeBlock)) {
            return;
        }
        HypertubeBlock block = (HypertubeBlock)blockState.getBlock();
        VertexConsumer vb = buffer.getBuffer(RenderType.lines());
        ms.pushPose();
        ms.translate((double)connection.pos().getX() - camera.x, (double)connection.pos().getY() - camera.y, (double)connection.pos().getZ() - camera.z);
        TrackBlockOutline.renderShape((VoxelShape)block.getShape(blockState), (PoseStack)ms, (VertexConsumer)vb, (Boolean)canPlace);
        ms.popPose();
    }

    static {
        canPlace = false;
        animation = LerpedFloat.linear().startWithValue(0.0);
    }
}

