/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks.blockentities;

import com.pedrorok.hypertube.blocks.HyperEntranceBlock;
import com.pedrorok.hypertube.blocks.blockentities.TubeBlockEntity;
import com.pedrorok.hypertube.core.sound.TubeSoundManager;
import com.pedrorok.hypertube.core.travel.TravelConstants;
import com.pedrorok.hypertube.registry.ModParticles;
import com.pedrorok.hypertube.registry.ModSounds;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class ActionTubeBlockEntity
extends TubeBlockEntity {
    private static final float RADIUS = 1.0f;
    protected final UUID tubeSoundId = UUID.randomUUID();

    public ActionTubeBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    protected void spawnSuctionParticle(Level level, BlockPos blockPos, Direction face) {
        face = face.getOpposite();
        Vec3 center = Vec3.atCenterOf((Vec3i)blockPos);
        RandomSource rand = level.getRandom();
        Vec3 faceNormal = Vec3.atLowerCornerOf((Vec3i)face.getNormal());
        double spread = 0.5;
        Vec3 tangentA = switch (face.getAxis()) {
            case Direction.Axis.Y, Direction.Axis.Z -> new Vec3(1.0, 0.0, 0.0);
            default -> new Vec3(0.0, 1.0, 0.0);
        };
        Vec3 tangentB = faceNormal.cross(tangentA).normalize();
        double offsetA = (rand.nextDouble() - 0.5) * 2.0 * spread;
        double offsetB = (rand.nextDouble() - 0.5) * 2.0 * spread;
        Vec3 randomOffset = tangentA.scale(offsetA).add(tangentB.scale(offsetB));
        Vec3 start = center.add(faceNormal.scale((double)(1.0f + level.random.nextFloat()))).add(randomOffset);
        Vec3 motion = center.subtract(start).normalize().scale(0.05);
        level.addParticle((ParticleOptions)ModParticles.SUCTION_PARTICLE.get(), start.x, start.y, start.z, motion.x, motion.y, motion.z);
    }

    protected void playOpenCloseSound(boolean open) {
        RandomSource random = this.level.random;
        float pitch = 0.4f + random.nextFloat() * 0.4f;
        this.level.playSound(null, this.getBlockPos(), open ? (SoundEvent)ModSounds.HYPERTUBE_ENTRANCE_OPEN.get() : (SoundEvent)ModSounds.HYPERTUBE_ENTRANCE_CLOSE.get(), SoundSource.BLOCKS, 0.2f, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void playClientEffects(TubeSoundManager.TubeAmbientSound sound) {
        BlockState state = this.getBlockState();
        BlockPos pos = this.getBlockPos();
        boolean isOpen = (Boolean)state.getValue((Property)HyperEntranceBlock.OPEN);
        LocalPlayer player = Minecraft.getInstance().player;
        Vec3 source = pos.getCenter();
        Vec3 listener = player.position();
        Vec3 worldDirection = source.subtract(listener).normalize();
        Vec3 forward = player.getLookAngle().normalize();
        Vec3 up = player.getUpVector(1.0f).normalize();
        Vec3 right = forward.cross(up).normalize();
        double x = worldDirection.dot(right);
        double y = worldDirection.dot(up);
        double z = worldDirection.dot(forward);
        Vec3 rotatedDirection = new Vec3(x, y, z).normalize();
        double distance = player.distanceToSqr(source);
        if (isOpen) {
            this.spawnSuctionParticle(this.level, pos, (Direction)state.getValue((Property)HyperEntranceBlock.FACING));
        }
        sound.enableClientPlayerSound((Entity)player, rotatedDirection, distance, isOpen);
    }

    @Nullable
    protected LivingEntity getInRangeLivingEntities(ServerLevel level, Vec3 centerPos, Direction facing) {
        Vec3 checkPos = centerPos.add(Vec3.atLowerCornerOf((Vec3i)facing.getOpposite().getNormal()));
        return level.getNearestEntity(level.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)checkPos, (double)1.5, (double)1.5, (double)1.5), entity -> TravelConstants.TRAVELLER_ENTITIES.contains(entity.getType())), TargetingConditions.forNonCombat().ignoreLineOfSight(), null, centerPos.x, centerPos.y, centerPos.z);
    }

    @Nullable
    protected LivingEntity getNearbyLivingEntities(ServerLevel level, Vec3 centerPos) {
        return level.getNearestEntity(level.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)centerPos, (double)6.0, (double)6.0, (double)6.0), entity -> TravelConstants.TRAVELLER_ENTITIES.contains(entity.getType())), TargetingConditions.forNonCombat().ignoreLineOfSight(), null, centerPos.x, centerPos.y, centerPos.z);
    }

    protected boolean isTubeClosed(boolean canOpen, boolean isOpen) {
        BlockState state = this.getBlockState();
        BlockPos pos = this.getBlockPos();
        if (!canOpen) {
            if (isOpen) {
                this.level.setBlock(pos, (BlockState)state.setValue((Property)HyperEntranceBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
                this.playOpenCloseSound(false);
            }
            return true;
        }
        if (!isOpen) {
            this.level.setBlock(pos, (BlockState)state.setValue((Property)HyperEntranceBlock.OPEN, (Comparable)Boolean.valueOf(true)), 3);
            this.playOpenCloseSound(true);
        }
        return false;
    }

    public void remove() {
        if (this.level.isClientSide) {
            this.removeClient();
        }
        super.remove();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void removeClient() {
        TubeSoundManager.getAmbientSound(this.tubeSoundId).stopSound();
        TubeSoundManager.removeAmbientSound(this.tubeSoundId);
    }
}

