/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.util;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ItemUtil {
    public static Item woolByColor(DyeColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Items.WHITE_WOOL;
            case DyeColor.ORANGE -> Items.ORANGE_WOOL;
            case DyeColor.MAGENTA -> Items.MAGENTA_WOOL;
            case DyeColor.LIGHT_BLUE -> Items.LIGHT_BLUE_WOOL;
            case DyeColor.YELLOW -> Items.YELLOW_WOOL;
            case DyeColor.LIME -> Items.LIME_WOOL;
            case DyeColor.PINK -> Items.PINK_WOOL;
            case DyeColor.GRAY -> Items.GRAY_WOOL;
            case DyeColor.LIGHT_GRAY -> Items.LIGHT_GRAY_WOOL;
            case DyeColor.CYAN -> Items.CYAN_WOOL;
            case DyeColor.PURPLE -> Items.PURPLE_WOOL;
            case DyeColor.BLUE -> Items.BLUE_WOOL;
            case DyeColor.BROWN -> Items.BROWN_WOOL;
            case DyeColor.GREEN -> Items.GREEN_WOOL;
            case DyeColor.RED -> Items.RED_WOOL;
            case DyeColor.BLACK -> Items.BLACK_WOOL;
        };
    }

    public static Item dyeByColor(DyeColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Items.WHITE_DYE;
            case DyeColor.ORANGE -> Items.ORANGE_DYE;
            case DyeColor.MAGENTA -> Items.MAGENTA_DYE;
            case DyeColor.LIGHT_BLUE -> Items.LIGHT_BLUE_DYE;
            case DyeColor.YELLOW -> Items.YELLOW_DYE;
            case DyeColor.LIME -> Items.LIME_DYE;
            case DyeColor.PINK -> Items.PINK_DYE;
            case DyeColor.GRAY -> Items.GRAY_DYE;
            case DyeColor.LIGHT_GRAY -> Items.LIGHT_GRAY_DYE;
            case DyeColor.CYAN -> Items.CYAN_DYE;
            case DyeColor.PURPLE -> Items.PURPLE_DYE;
            case DyeColor.BLUE -> Items.BLUE_DYE;
            case DyeColor.BROWN -> Items.BROWN_DYE;
            case DyeColor.GREEN -> Items.GREEN_DYE;
            case DyeColor.RED -> Items.RED_DYE;
            case DyeColor.BLACK -> Items.BLACK_DYE;
        };
    }

    public static boolean moveItemStackTo(ItemStack stack, Container target, boolean reverseDirection) {
        ItemStack itemStack;
        int startIndex = 0;
        int endIndex = target.getContainerSize();
        boolean bl = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.isStackable()) {
            while (!stack.isEmpty() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                itemStack = target.getItem(i);
                if (!itemStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack)) {
                    int j = itemStack.getCount() + stack.getCount();
                    if (j <= stack.getMaxStackSize()) {
                        stack.setCount(0);
                        itemStack.setCount(j);
                        target.setChanged();
                        bl = true;
                    } else if (itemStack.getCount() < stack.getMaxStackSize()) {
                        stack.shrink(stack.getMaxStackSize() - itemStack.getCount());
                        itemStack.setCount(stack.getMaxStackSize());
                        target.setChanged();
                        bl = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.isEmpty()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                itemStack = target.getItem(i);
                if (itemStack.isEmpty() && target.canPlaceItem(i, stack)) {
                    if (stack.getCount() > target.getMaxStackSize()) {
                        target.setItem(i, stack.split(target.getMaxStackSize()));
                    } else {
                        target.setItem(i, stack.split(stack.getCount()));
                    }
                    target.setChanged();
                    bl = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return bl;
    }

    public static void givePlayerItem(Player player, ItemStack itemstack) {
        if (player.addItem(itemstack)) {
            player.level().playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.containerMenu.broadcastChanges();
            }
        } else {
            ItemEntity itementity = player.drop(itemstack, false);
            if (itementity != null) {
                itementity.setNoPickUpDelay();
                itementity.setTarget(player.getUUID());
            }
        }
    }
}

