/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.registry;

import com.simibubi.create.content.processing.sequenced.SequencedAssemblyItem;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.bank.CardItem;
import dev.ithundxr.createnumismatics.content.bank.IDCardItem;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BlazeBankerBlock;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlocks;
import dev.ithundxr.createnumismatics.registry.NumismaticsItems;
import dev.ithundxr.createnumismatics.registry.neoforge.NumismaticsCreativeModeTabsImpl;
import dev.ithundxr.createnumismatics.registry.neoforge.NumismaticsCreativeModeTabsRegistrateDisplayItemsGeneratorImpl;
import dev.ithundxr.createnumismatics.registry.neoforge.NumismaticsCreativeModeTabsTabsImpl;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.mutable.MutableObject;

public class NumismaticsCreativeModeTabs {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static CreativeModeTab getBaseTab() {
        return NumismaticsCreativeModeTabsImpl.getBaseTab();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ResourceKey<CreativeModeTab> getBaseTabKey() {
        return NumismaticsCreativeModeTabsImpl.getBaseTabKey();
    }

    public static void register() {
        Numismatics.LOGGER.info("Registering creative tabs for Create: Numismatics");
    }

    public static final class RegistrateDisplayItemsGenerator
    implements CreativeModeTab.DisplayItemsGenerator {
        private static final Predicate<Item> IS_ITEM_3D_PREDICATE;
        private final Tabs tab;
        private static final DyeColor[] COLOR_ORDER;

        public RegistrateDisplayItemsGenerator(Tabs tab) {
            this.tab = tab;
        }

        private static Predicate<Item> makeExclusionPredicate() {
            ReferenceOpenHashSet exclusions = new ReferenceOpenHashSet();
            List<BlockEntry<BlazeBankerBlock>> simpleExclusions = List.of(NumismaticsBlocks.BLAZE_BANKER);
            for (ItemProviderEntry itemProviderEntry : simpleExclusions) {
                exclusions.add(itemProviderEntry.asItem());
            }
            return arg_0 -> RegistrateDisplayItemsGenerator.lambda$makeExclusionPredicate$2((Set)exclusions, arg_0);
        }

        private static List<ItemOrdering> makeOrderings() {
            ReferenceArrayList orderings = new ReferenceArrayList();
            Map<ItemProviderEntry, ItemProviderEntry> simpleBeforeOrderings = Map.of();
            Map<ItemProviderEntry, ItemProviderEntry> simpleAfterOrderings = Map.of();
            simpleBeforeOrderings.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeOrderings$3((List)orderings, arg_0, arg_1));
            simpleAfterOrderings.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeOrderings$4((List)orderings, arg_0, arg_1));
            return orderings;
        }

        private static Function<Item, ItemStack> makeStackFunc() {
            Reference2ReferenceOpenHashMap factories = new Reference2ReferenceOpenHashMap();
            Map<ItemProviderEntry, Function> simpleFactories = Map.of();
            simpleFactories.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeStackFunc$5((Map)factories, arg_0, arg_1));
            return arg_0 -> RegistrateDisplayItemsGenerator.lambda$makeStackFunc$6((Map)factories, arg_0);
        }

        private static Function<Item, CreativeModeTab.TabVisibility> makeVisibilityFunc() {
            Item item;
            Reference2ObjectOpenHashMap visibilities = new Reference2ObjectOpenHashMap();
            Map<ItemProviderEntry, CreativeModeTab.TabVisibility> simpleVisibilities = Map.of();
            simpleVisibilities.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeVisibilityFunc$7((Map)visibilities, arg_0, arg_1));
            for (ItemEntry<CardItem> itemEntry : NumismaticsItems.CARDS) {
                item = (CardItem)((Object)itemEntry.get());
                if (item.color == DyeColor.RED) continue;
                visibilities.put(item, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
            }
            for (ItemEntry itemEntry : NumismaticsItems.ID_CARDS) {
                item = (IDCardItem)((Object)itemEntry.get());
                if (item.color == DyeColor.RED) continue;
                visibilities.put(item, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
            }
            return arg_0 -> RegistrateDisplayItemsGenerator.lambda$makeVisibilityFunc$8((Map)visibilities, arg_0);
        }

        public void accept(CreativeModeTab.ItemDisplayParameters pParameters, CreativeModeTab.Output output) {
            Predicate<Item> exclusionPredicate = RegistrateDisplayItemsGenerator.makeExclusionPredicate();
            List<ItemOrdering> orderings = RegistrateDisplayItemsGenerator.makeOrderings();
            Function<Item, ItemStack> stackFunc = RegistrateDisplayItemsGenerator.makeStackFunc();
            Function<Item, CreativeModeTab.TabVisibility> visibilityFunc = RegistrateDisplayItemsGenerator.makeVisibilityFunc();
            LinkedList<Item> items = new LinkedList<Item>();
            items.addAll(this.collectItems(exclusionPredicate.or(IS_ITEM_3D_PREDICATE.negate())));
            items.addAll(this.collectBlocks(exclusionPredicate));
            items.addAll(this.collectItems(exclusionPredicate.or(IS_ITEM_3D_PREDICATE)));
            RegistrateDisplayItemsGenerator.applyOrderings(items, orderings);
            RegistrateDisplayItemsGenerator.outputAll(output, items, stackFunc, visibilityFunc);
        }

        private List<Item> collectBlocks(Predicate<Item> exclusionPredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (RegistryEntry entry : Numismatics.registrate().getAll(Registries.BLOCK)) {
                Item item;
                if (!RegistrateDisplayItemsGenerator.isInCreativeTab(entry, this.tab.getKey()) || (item = ((Block)entry.get()).asItem()) == Items.AIR || exclusionPredicate.test(item)) continue;
                items.add(item);
            }
            items = new ReferenceArrayList((ReferenceCollection)new ReferenceLinkedOpenHashSet((Collection)items));
            return items;
        }

        private List<Item> collectItems(Predicate<Item> exclusionPredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (RegistryEntry entry : Numismatics.registrate().getAll(Registries.ITEM)) {
                Item item;
                if (!RegistrateDisplayItemsGenerator.isInCreativeTab(entry, this.tab.getKey()) || (item = (Item)entry.get()) instanceof BlockItem || exclusionPredicate.test(item)) continue;
                items.add(item);
            }
            return items;
        }

        /*
         * WARNING - void declaration
         */
        @ExpectPlatform
        @ExpectPlatform.Transformed
        private static boolean isInCreativeTab(RegistryEntry<?, ?> entry, ResourceKey<CreativeModeTab> tab) {
            void var1_1;
            return NumismaticsCreativeModeTabsRegistrateDisplayItemsGeneratorImpl.isInCreativeTab(entry, (ResourceKey<CreativeModeTab>)var1_1);
        }

        private static void applyOrderings(List<Item> items, List<ItemOrdering> orderings) {
            for (ItemOrdering ordering : orderings) {
                int anchorIndex = items.indexOf(ordering.anchor());
                if (anchorIndex == -1) continue;
                Item item = ordering.item();
                int itemIndex = items.indexOf(item);
                if (itemIndex != -1) {
                    items.remove(itemIndex);
                    if (itemIndex < anchorIndex) {
                        --anchorIndex;
                    }
                }
                if (ordering.type() == ItemOrdering.Type.AFTER) {
                    items.add(anchorIndex + 1, item);
                    continue;
                }
                items.add(anchorIndex, item);
            }
        }

        private static void outputAll(CreativeModeTab.Output output, List<Item> items, Function<Item, ItemStack> stackFunc, Function<Item, CreativeModeTab.TabVisibility> visibilityFunc) {
            for (Item item : items) {
                output.accept(stackFunc.apply(item), visibilityFunc.apply(item));
            }
        }

        private static /* synthetic */ CreativeModeTab.TabVisibility lambda$makeVisibilityFunc$8(Map visibilities, Item item) {
            CreativeModeTab.TabVisibility visibility = (CreativeModeTab.TabVisibility)visibilities.get(item);
            return Objects.requireNonNullElse(visibility, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }

        private static /* synthetic */ void lambda$makeVisibilityFunc$7(Map visibilities, ItemProviderEntry entry, CreativeModeTab.TabVisibility factory) {
            visibilities.put(entry.asItem(), factory);
        }

        private static /* synthetic */ ItemStack lambda$makeStackFunc$6(Map factories, Item item) {
            Function factory = (Function)factories.get(item);
            if (factory != null) {
                return (ItemStack)factory.apply(item);
            }
            return new ItemStack((ItemLike)item);
        }

        private static /* synthetic */ void lambda$makeStackFunc$5(Map factories, ItemProviderEntry entry, Function factory) {
            factories.put(entry.asItem(), factory);
        }

        private static /* synthetic */ void lambda$makeOrderings$4(List orderings, ItemProviderEntry entry, ItemProviderEntry otherEntry) {
            orderings.add(ItemOrdering.after(entry.asItem(), otherEntry.asItem()));
        }

        private static /* synthetic */ void lambda$makeOrderings$3(List orderings, ItemProviderEntry entry, ItemProviderEntry otherEntry) {
            orderings.add(ItemOrdering.before(entry.asItem(), otherEntry.asItem()));
        }

        private static /* synthetic */ boolean lambda$makeExclusionPredicate$2(Set exclusions, Item item) {
            return exclusions.contains(item) || item instanceof SequencedAssemblyItem;
        }

        static {
            MutableObject isItem3d = new MutableObject(item -> false);
            if (CatnipServices.PLATFORM.getEnv().isClient()) {
                isItem3d.setValue(item -> {
                    ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
                    BakedModel model = itemRenderer.getModel(new ItemStack((ItemLike)item), null, null, 0);
                    return model.isGui3d();
                });
            }
            IS_ITEM_3D_PREDICATE = (Predicate)isItem3d.getValue();
            COLOR_ORDER = new DyeColor[]{DyeColor.RED, DyeColor.ORANGE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.GREEN, DyeColor.LIGHT_BLUE, DyeColor.CYAN, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.PINK, DyeColor.BROWN, DyeColor.BLACK, DyeColor.GRAY, DyeColor.LIGHT_GRAY, DyeColor.WHITE};
        }

        private record ItemOrdering(Item item, Item anchor, Type type) {
            public static ItemOrdering before(Item item, Item anchor) {
                return new ItemOrdering(item, anchor, Type.BEFORE);
            }

            public static ItemOrdering after(Item item, Item anchor) {
                return new ItemOrdering(item, anchor, Type.AFTER);
            }

            public static enum Type {
                BEFORE,
                AFTER;

            }
        }
    }

    public static enum Tabs {
        MAIN(NumismaticsCreativeModeTabs::getBaseTabKey);

        private final Supplier<ResourceKey<CreativeModeTab>> keySupplier;

        private Tabs(Supplier<ResourceKey<CreativeModeTab>> keySupplier) {
            this.keySupplier = keySupplier;
        }

        public ResourceKey<CreativeModeTab> getKey() {
            return this.keySupplier.get();
        }

        public void use() {
            Tabs.use(this);
        }

        @ExpectPlatform
        @ExpectPlatform.Transformed
        private static void use(Tabs tab) {
            NumismaticsCreativeModeTabsTabsImpl.use(tab);
        }
    }
}

