/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.coins;

import com.mojang.datafixers.util.Pair;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.content.coins.DiscreteCoinBag;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlotDiscreteCoinBag
extends Slot {
    private static final Container emptyInventory = new SimpleContainer(0);
    private final DiscreteCoinBag coinBag;
    private final Coin coin;
    private final boolean canInsert;
    private final boolean canExtract;

    public SlotDiscreteCoinBag(DiscreteCoinBag coinBag, Coin coin, int x, int y, boolean canInsert, boolean canExtract) {
        super(emptyInventory, 0, x, y);
        this.coinBag = coinBag;
        this.coin = coin;
        this.canInsert = canInsert;
        this.canExtract = canExtract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mayPlace(ItemStack stack) {
        if (!this.canInsert) {
            return false;
        }
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        if (!(item instanceof CoinItem)) return false;
        CoinItem coinItem = (CoinItem)item;
        if (coinItem.coin != this.coin) return false;
        return true;
    }

    @NotNull
    public ItemStack getItem() {
        return this.coinBag.asStack(this.coin);
    }

    public void set(ItemStack stack) {
        block3: {
            block2: {
                if (stack.isEmpty()) break block2;
                Item item = stack.getItem();
                if (!(item instanceof CoinItem)) break block3;
                CoinItem coinItem = (CoinItem)item;
                if (coinItem.coin != this.coin) break block3;
            }
            this.coinBag.setDiscrete(this.coin, stack.getCount());
            this.setChanged();
        }
    }

    public void onQuickCraft(@NotNull ItemStack oldStackIn, @NotNull ItemStack newStackIn) {
    }

    public int getMaxStackSize() {
        return Integer.MAX_VALUE;
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.getMaxStackSize();
    }

    public boolean mayPickup(@NotNull Player player) {
        if (!this.canExtract) {
            return false;
        }
        return this.coinBag.getDiscrete(this.coin) > 0;
    }

    @NotNull
    public ItemStack remove(int amount) {
        if ((amount = Math.min(amount, this.coinBag.getDiscrete(this.coin))) <= 0) {
            return ItemStack.EMPTY;
        }
        this.coinBag.subtract(this.coin, amount);
        return this.coin.asStack(amount);
    }

    public boolean tryPlace(ItemStack stack) {
        if (!this.mayPlace(stack)) {
            return false;
        }
        this.coinBag.add(this.coin, stack.getCount());
        stack.setCount(0);
        this.setChanged();
        return true;
    }

    @NotNull
    public Optional<ItemStack> tryRemove(int count, int decrement, @NotNull Player player) {
        return super.tryRemove(count, Math.min(64, decrement), player);
    }

    @Nullable
    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)Numismatics.asResource("item/coin/outline/" + this.coin.getName()));
    }
}

