/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.events.behaviors;

import net.mehvahdjukaar.amendments.common.tile.DoubleSkullBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.InteractEvents;
import net.mehvahdjukaar.amendments.events.behaviors.ItemUseOnBlock;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.amendments.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

class SkullPileConversion
implements ItemUseOnBlock {
    SkullPileConversion() {
    }

    @Override
    public boolean altersWorld() {
        return true;
    }

    @Override
    public boolean placesBlock() {
        return true;
    }

    @Override
    @Nullable
    public MutableComponent getTooltip() {
        return Component.translatable((String)"message.amendments.double_cake");
    }

    @Override
    public boolean isEnabled() {
        return CommonConfigs.SKULL_PILES.get();
    }

    @Override
    public boolean appliesToItem(Item item) {
        BlockItem bi;
        return item instanceof BlockItem && (bi = (BlockItem)item).getBlock() instanceof SkullBlock && !item.builtInRegistryHolder().is(ModTags.SKULL_PILE_BLACKLIST);
    }

    @Override
    public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit) {
        SkullBlock skullBlock;
        SkullBlockEntity oldTile;
        BlockState state;
        Block block;
        BlockPos pos = hit.getBlockPos();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof SkullBlockEntity && (block = (state = (oldTile = (SkullBlockEntity)blockEntity).getBlockState()).getBlock()) instanceof SkullBlock && (skullBlock = (SkullBlock)block).getType() != SkullBlock.Types.DRAGON) {
            BlockEntity blockEntity2;
            ItemStack copy = stack.copy();
            InteractionResult result = InteractEvents.replaceSimilarBlock(ModRegistry.SKULL_PILE.get(), player, stack, pos, world, state, null, true, true, new Property[]{SkullBlock.ROTATION});
            if (result.consumesAction() && (blockEntity2 = world.getBlockEntity(pos)) instanceof DoubleSkullBlockTile) {
                DoubleSkullBlockTile tile = (DoubleSkullBlockTile)blockEntity2;
                tile.initialize(oldTile, copy, player, hand);
            }
            return result;
        }
        return InteractionResult.PASS;
    }
}

