/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.mixin.logistics.stockKeeper;

import com.simibubi.create.compat.jei.StockKeeperTransferHandler;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.stockTicker.CraftableBigItemStack;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestMenu;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestScreen;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.foundation.blockEntity.LegacyRecipeWrapper;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.library.transfer.RecipeTransferErrorMissingSlots;
import mezz.jei.library.transfer.RecipeTransferErrorTooltip;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericIngredient;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.compat.jei.IngredientTransfer;
import ru.zznty.create_factory_abstractions.compat.jei.TransferOperation;
import ru.zznty.create_factory_abstractions.compat.jei.TransferOperationsResult;
import ru.zznty.create_factory_abstractions.generic.support.CraftableGenericStack;
import ru.zznty.create_factory_abstractions.generic.support.GenericInventorySummary;

@Mixin(value={StockKeeperTransferHandler.class})
public class StockKeeperTransferHandlerMixin {
    @Shadow
    private IJeiHelpers helpers;

    @Overwrite
    @Nullable
    private IRecipeTransferError transferRecipeOnClient(StockKeeperRequestMenu container, RecipeHolder<Recipe<?>> recipeHolder, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        Object object = container.screenReference;
        if (!(object instanceof StockKeeperRequestScreen)) {
            return null;
        }
        StockKeeperRequestScreen screen = (StockKeeperRequestScreen)object;
        Recipe recipe = recipeHolder.value();
        for (CraftableBigItemStack cbis : screen.recipesToOrder) {
            if (cbis.recipe != recipe) continue;
            return new RecipeTransferErrorTooltip((Component)CreateLang.translate((String)"gui.stock_keeper.already_ordering_recipe", (Object[])new Object[0]).component());
        }
        if (screen.itemsToOrder.size() >= 9) {
            return new RecipeTransferErrorTooltip((Component)CreateLang.translate((String)"gui.stock_keeper.slots_full", (Object[])new Object[0]).component());
        }
        GenericInventorySummary summary = GenericInventorySummary.of((InventorySummary)((StockTickerBlockEntity)((StockKeeperRequestMenu)screen.getMenu()).contentHolder).getLastClientsideStockSnapshotAsSummary());
        if (summary == null) {
            return null;
        }
        List availableStacks = summary.get();
        LegacyRecipeWrapper outputDummy = new LegacyRecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(9));
        ArrayList<Slot> craftingSlots = new ArrayList<Slot>();
        for (int i = 0; i < outputDummy.getContainerSize(); ++i) {
            craftingSlots.add(new Slot((Container)outputDummy, i, 0, 0));
        }
        TransferOperationsResult transferOperations = IngredientTransfer.getRecipeTransferOperations((IIngredientManager)this.helpers.getIngredientManager(), (List)availableStacks, (List)recipeSlots.getSlotViews(RecipeIngredientRole.INPUT), craftingSlots);
        if (!transferOperations.missingItems().isEmpty()) {
            return new RecipeTransferErrorMissingSlots((Component)CreateLang.translate((String)"gui.stock_keeper.not_in_stock", (Object[])new Object[0]).component(), (Collection)transferOperations.missingItems());
        }
        if ((long)screen.itemsToOrder.size() + transferOperations.results().stream().mapToInt(TransferOperation::from).distinct().count() >= 9L) {
            return new RecipeTransferErrorTooltip((Component)CreateLang.translate((String)"gui.stock_keeper.slots_full", (Object[])new Object[0]).component());
        }
        if (!doTransfer) {
            return null;
        }
        RegistryAccess registryAccess = player.level().registryAccess();
        CraftableBigItemStack cbis = new CraftableBigItemStack(recipe.getResultItem((HolderLookup.Provider)registryAccess), recipe);
        CraftableGenericStack ingredientStack = CraftableGenericStack.of((CraftableBigItemStack)cbis);
        ingredientStack.setAmount(0);
        for (TransferOperation operation : transferOperations.results()) {
            IIngredientHelper helper = this.helpers.getIngredientManager().getIngredientHelper(operation.selectedIngredient().getType());
            ingredientStack.ingredients().add(GenericIngredient.of((GenericStack)((GenericStack)availableStacks.get(operation.from())).withAmount((int)helper.getAmount(operation.selectedIngredient().getIngredient()))));
        }
        for (IRecipeSlotView slotView : recipeSlots.getSlotViews(RecipeIngredientRole.OUTPUT)) {
            Optional ingredient;
            Optional displayedIngredient = slotView.getDisplayedIngredient();
            if (displayedIngredient.isEmpty() || (ingredient = IngredientTransfer.tryConvert((IIngredientManager)this.helpers.getIngredientManager(), (ITypedIngredient)((ITypedIngredient)displayedIngredient.get()))).isEmpty()) continue;
            ingredientStack.results(registryAccess).add((GenericStack)ingredient.get());
        }
        if (cbis.stack.isEmpty() && !ingredientStack.results(registryAccess).isEmpty()) {
            ingredientStack.set(((GenericStack)ingredientStack.results(registryAccess).get(0)).withAmount(0));
        }
        screen.recipesToOrder.add(cbis);
        screen.searchBox.setValue("");
        screen.refreshSearchNextTick = true;
        screen.requestCraftable(cbis, maxTransfer && !cbis.stack.isEmpty() ? cbis.stack.getMaxStackSize() : 1);
        return null;
    }
}

