/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.mixin.logistics.stockKeeper;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.logistics.AddressEditBox;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.stockTicker.CraftableBigItemStack;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestMenu;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestScreen;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.platform.services.NetworkHelper;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import ru.zznty.create_factory_abstractions.api.generic.crafting.OrderProvider;
import ru.zznty.create_factory_abstractions.api.generic.crafting.RecipeRequestHelper;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKey;
import ru.zznty.create_factory_abstractions.api.generic.search.CategoriesProvider;
import ru.zznty.create_factory_abstractions.api.generic.search.GenericSearch;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.generic.impl.GenericContentExtender;
import ru.zznty.create_factory_abstractions.generic.support.BigGenericStack;
import ru.zznty.create_factory_abstractions.generic.support.CraftableGenericStack;
import ru.zznty.create_factory_abstractions.generic.support.GenericInventorySummary;
import ru.zznty.create_factory_abstractions.generic.support.GenericOrder;
import ru.zznty.create_factory_logistics.logistics.panel.request.PackageOrderRequestPacket;
import ru.zznty.create_factory_logistics.mixin.accessor.CategoryEntryAccessor;
import ru.zznty.create_factory_logistics.mixin.accessor.StockTickerBlockEntityAccessor;

@Mixin(value={StockKeeperRequestScreen.class})
public abstract class StockKeeperRequestScreenMixin
extends AbstractSimiContainerScreen<StockKeeperRequestMenu>
implements OrderProvider,
CategoriesProvider {
    @Shadow
    private InventorySummary forcedEntries;
    @Shadow
    public List<BigGenericStack> itemsToOrder;
    @Shadow
    StockTickerBlockEntity blockEntity;
    @Shadow
    public List<List<BigGenericStack>> currentItemSource;
    @Shadow
    public List<CraftableGenericStack> recipesToOrder;
    @Shadow
    private boolean canRequestCraftingPackage;
    @Shadow
    private boolean encodeRequester;
    @Shadow
    public AddressEditBox addressBox;
    @Shadow
    public LerpedFloat itemScroll;
    @Shadow
    public List<List<BigGenericStack>> displayedItems;
    @Shadow
    public EditBox searchBox;
    @Shadow
    final int cols = 9;
    @Shadow
    final int rowHeight = 20;
    @Shadow
    private Set<Integer> hiddenCategories;
    @Shadow
    public List<StockKeeperRequestScreen.CategoryEntry> categories;

    public StockKeeperRequestScreenMixin(StockKeeperRequestMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
    }

    @Shadow
    private Pair<Integer, List<List<BigItemStack>>> maxCraftable(CraftableBigItemStack cbis, InventorySummary summary, Function<ItemStack, Integer> countModifier, int newTypeLimit) {
        return null;
    }

    @Shadow
    private void clampScrollBar() {
    }

    @Shadow
    public boolean isSchematicListMode() {
        return false;
    }

    @Shadow
    public void requestSchematicList() {
    }

    @Redirect(method={"containerTick()V"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/packager/InventorySummary;getCountOf(Lnet/minecraft/world/item/ItemStack;)I"))
    private int getCountInForced(InventorySummary instance, ItemStack $, @Local BigItemStack entry) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)entry);
        return GenericInventorySummary.of((InventorySummary)instance).getCountOf(stack.get().key());
    }

    @Redirect(method={"containerTick()V"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/packager/InventorySummary;erase(Lnet/minecraft/world/item/ItemStack;)Z"))
    private boolean eraseFromForced(InventorySummary instance, ItemStack $, @Local BigItemStack entry) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)entry);
        return GenericInventorySummary.of((InventorySummary)instance).erase(stack.get().key());
    }

    @Redirect(method={"mouseClicked(DDI)Z"}, at=@At(value="NEW", target="(Lnet/minecraft/world/item/ItemStack;I)Lcom/simibubi/create/content/logistics/BigItemStack;"))
    private BigItemStack createOrderForIngredientInClicked(ItemStack $, int count, @Local(ordinal=0) BigItemStack entry) {
        BigGenericStack genericStack = BigGenericStack.of((GenericStack)BigGenericStack.of((BigItemStack)entry).get().withAmount(1));
        genericStack.setAmount(0);
        return genericStack.asStack();
    }

    @Redirect(method={"mouseScrolled(DDDD)Z"}, at=@At(value="NEW", target="(Lnet/minecraft/world/item/ItemStack;I)Lcom/simibubi/create/content/logistics/BigItemStack;"))
    private BigItemStack createOrderForIngredientInScrolled(ItemStack $, int count, @Local(ordinal=0) BigItemStack entry) {
        BigGenericStack genericStack = BigGenericStack.of((GenericStack)BigGenericStack.of((BigItemStack)entry).get().withAmount(1));
        genericStack.setAmount(0);
        return genericStack.asStack();
    }

    @Redirect(method={"mouseScrolled(DDDD)Z"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/packager/InventorySummary;getCountOf(Lnet/minecraft/world/item/ItemStack;)I"))
    private int getCountInSummary(InventorySummary instance, ItemStack $, @Local(ordinal=0) BigItemStack entry) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)entry);
        return GenericInventorySummary.of((InventorySummary)instance).getCountOf(stack.get().key());
    }

    @Unique
    private BigGenericStack createFactoryLogistics$getOrderForStack(GenericStack stack) {
        for (BigGenericStack entry : this.itemsToOrder) {
            if (!entry.get().canStack(stack)) continue;
            return entry;
        }
        return null;
    }

    @Redirect(method={"mouseClicked(DDI)Z"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/stockTicker/StockKeeperRequestScreen;getOrderForItem(Lnet/minecraft/world/item/ItemStack;)Lcom/simibubi/create/content/logistics/BigItemStack;"))
    private BigItemStack getExistingOrderInClicked(StockKeeperRequestScreen instance, ItemStack $, @Local BigItemStack itemStack) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)itemStack);
        BigGenericStack order = this.createFactoryLogistics$getOrderForStack(stack.get());
        return order == null ? null : order.asStack();
    }

    @Redirect(method={"renderItemEntry(Lnet/minecraft/client/gui/GuiGraphics;FLcom/simibubi/create/content/logistics/BigItemStack;ZZ)V"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/stockTicker/StockKeeperRequestScreen;getOrderForItem(Lnet/minecraft/world/item/ItemStack;)Lcom/simibubi/create/content/logistics/BigItemStack;"))
    private BigItemStack getExistingOrderInRender(StockKeeperRequestScreen instance, ItemStack $, @Local(argsOnly=true) BigItemStack itemStack) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)itemStack);
        BigGenericStack order = this.createFactoryLogistics$getOrderForStack(stack.get());
        return order == null ? null : order.asStack();
    }

    @Redirect(method={"mouseClicked(DDI)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getMaxStackSize()I"))
    private int getMaxStackSize(ItemStack instance, @Local BigItemStack itemStack) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)itemStack);
        return GenericContentExtender.registrationOf((GenericKey)stack.get().key()).clientProvider().guiHandler().stackSize(stack.get().key());
    }

    @Redirect(method={"mouseScrolled(DDDD)Z"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/stockTicker/StockKeeperRequestScreen;getOrderForItem(Lnet/minecraft/world/item/ItemStack;)Lcom/simibubi/create/content/logistics/BigItemStack;"))
    private BigItemStack getExistingOrderInScrolled(StockKeeperRequestScreen instance, ItemStack $, @Local BigItemStack itemStack) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)itemStack);
        BigGenericStack order = this.createFactoryLogistics$getOrderForStack(stack.get());
        return order == null ? null : order.asStack();
    }

    @Overwrite
    private void revalidateOrders() {
        HashSet<BigGenericStack> invalid = new HashSet<BigGenericStack>(this.itemsToOrder);
        GenericInventorySummary summary = GenericInventorySummary.of((InventorySummary)this.blockEntity.getLastClientsideStockSnapshotAsSummary());
        if (this.currentItemSource == null || summary == null) {
            this.itemsToOrder.removeAll(invalid);
            return;
        }
        for (BigGenericStack stack : this.itemsToOrder) {
            stack.setAmount(Math.min(summary.getCountOf(stack.get().key()), stack.get().amount()));
            if (stack.get().amount() <= 0) continue;
            invalid.remove(stack);
        }
        this.itemsToOrder.removeAll(invalid);
    }

    @Redirect(method={"renderForeground(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;renderTooltip(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;II)V"))
    private void renderTooltip(GuiGraphics instance, Font p_282308_, ItemStack p_282781_, int p_282687_, int p_282292_, @Local BigItemStack itemStack, @Local(ordinal=1) boolean orderHovered) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)itemStack);
        BigGenericStack order = this.createFactoryLogistics$getOrderForStack(stack.get());
        int customCount = stack.get().amount();
        if (stack.get().amount() < 1000000000 && !orderHovered) {
            int forcedCount = GenericInventorySummary.of((InventorySummary)this.forcedEntries).getCountOf(stack.get().key());
            if (forcedCount != 0) {
                customCount = Math.min(customCount, -forcedCount - 1);
            }
            if (order != null) {
                customCount -= order.get().amount();
            }
            customCount = Math.max(0, customCount);
        }
        instance.renderComponentTooltip(p_282308_, GenericContentExtender.registrationOf((GenericKey)stack.get().key()).clientProvider().guiHandler().tooltipBuilder(stack.get().key(), customCount), p_282687_, p_282292_);
    }

    @Redirect(method={"renderForeground(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getTooltipLines(Lnet/minecraft/world/item/Item$TooltipContext;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/TooltipFlag;)Ljava/util/List;"))
    private List<Component> getCraftableTooltip(ItemStack instance, Item.TooltipContext i, Player list, TooltipFlag tooltipFlag, @Local BigItemStack itemStack) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)itemStack);
        return GenericContentExtender.registrationOf((GenericKey)stack.get().key()).clientProvider().guiHandler().tooltipBuilder(stack.get().key(), stack.get().amount());
    }

    @Overwrite
    private void refreshSearchResults(boolean scrollBackUp) {
        this.displayedItems = Collections.emptyList();
        if (scrollBackUp) {
            this.itemScroll.startWithValue(0.0);
        }
        if (this.currentItemSource == null) {
            this.clampScrollBar();
            return;
        }
        if (this.isSchematicListMode()) {
            this.clampScrollBar();
            this.requestSchematicList();
            return;
        }
        GenericSearch.SearchResult result = GenericSearch.search((CategoriesProvider)this, (String)this.searchBox.getValue(), (int)20, (int)9);
        this.displayedItems = result.displayedItems();
        this.categories = new ArrayList<StockKeeperRequestScreen.CategoryEntry>(result.categories().size());
        for (int i = 0; i < result.categories().size(); ++i) {
            GenericSearch.CategoryEntry entry = (GenericSearch.CategoryEntry)result.categories().get(i);
            StockKeeperRequestScreen.CategoryEntry categoryEntry = new StockKeeperRequestScreen.CategoryEntry(entry.targetCategory(), entry.name(), entry.y().getValue().intValue());
            ((CategoryEntryAccessor)categoryEntry).setHidden(entry.hidden().getValue());
            this.categories.add(categoryEntry);
        }
        this.clampScrollBar();
        this.updateCraftableAmounts();
    }

    @Redirect(method={"renderItemEntry(Lnet/minecraft/client/gui/GuiGraphics;FLcom/simibubi/create/content/logistics/BigItemStack;ZZ)V"}, at=@At(value="INVOKE", target="Lnet/createmod/catnip/gui/element/GuiGameElement;of(Lnet/minecraft/world/item/ItemStack;)Lnet/createmod/catnip/gui/element/GuiGameElement$GuiRenderBuilder;"))
    private GuiGameElement.GuiRenderBuilder renderIngredientEntry(ItemStack itemStack, @Local(argsOnly=true) BigItemStack entry, @Local(argsOnly=true) GuiGraphics graphics) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)entry);
        GenericContentExtender.registrationOf((GenericKey)stack.get().key()).clientProvider().guiHandler().renderSlot(graphics, stack.get().key(), 0, 0);
        return GuiGameElement.of((ItemLike)Blocks.AIR);
    }

    @Redirect(method={"renderItemEntry(Lnet/minecraft/client/gui/GuiGraphics;FLcom/simibubi/create/content/logistics/BigItemStack;ZZ)V"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/stockTicker/StockKeeperRequestScreen;drawItemCount(Lnet/minecraft/client/gui/GuiGraphics;II)V"))
    private void renderIngredientEntryAmount(StockKeeperRequestScreen instance, GuiGraphics graphics, int count, int customCount, @Local(argsOnly=true) BigItemStack entry, @Local(argsOnly=true, ordinal=0) boolean isStackHovered, @Local(argsOnly=true, ordinal=1) boolean isRenderingOrders) {
        if (isStackHovered && isRenderingOrders && !(entry instanceof CraftableBigItemStack)) {
            return;
        }
        BigGenericStack stack = BigGenericStack.of((BigItemStack)entry);
        count = customCount;
        GenericContentExtender.registrationOf((GenericKey)stack.get().key()).clientProvider().guiHandler().renderDecorations(graphics, stack.get().key(), count, 1, 1);
    }

    @Redirect(method={"mouseClicked(DDI)Z"}, at=@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/BigItemStack;count:I", ordinal=1))
    private void decreaseOrderCount(BigItemStack instance, int count) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)instance);
        stack.setAmount(count);
    }

    @Redirect(method={"mouseClicked(DDI)Z"}, at=@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/BigItemStack;count:I", ordinal=4))
    private void increaseOrderCount(BigItemStack instance, int count) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)instance);
        stack.setAmount(count);
    }

    @Redirect(method={"mouseScrolled(DDDD)Z"}, at=@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/BigItemStack;count:I", ordinal=1))
    private void scrollDecreaseOrderCount(BigItemStack instance, int count) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)instance);
        stack.setAmount(count);
    }

    @Redirect(method={"mouseScrolled(DDDD)Z"}, at=@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/BigItemStack;count:I", ordinal=4))
    private void scrollIncreaseOrderCount(BigItemStack instance, int count) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)instance);
        stack.setAmount(count);
    }

    @Overwrite
    private void updateCraftableAmounts() {
        this.canRequestCraftingPackage = RecipeRequestHelper.updateCraftableAmounts((OrderProvider)this);
    }

    @WrapOperation(method={"sendIt()V"}, at={@At(value="INVOKE", target="Lnet/createmod/catnip/platform/services/NetworkHelper;sendToServer(Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload;)V")})
    private void sendRequest(NetworkHelper instance, CustomPacketPayload customPacketPayload, Operation<Void> original, @Local PackageOrderWithCrafts order) {
        PackageOrderRequestPacket packet = new PackageOrderRequestPacket(this.blockEntity.getBlockPos(), GenericOrder.of((PackageOrderWithCrafts)order), this.addressBox.getValue(), this.encodeRequester);
        instance.sendToServer((CustomPacketPayload)packet);
    }

    @WrapOperation(method={"removed()V"}, at={@At(value="INVOKE", target="Lnet/createmod/catnip/platform/services/NetworkHelper;sendToServer(Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload;)V", ordinal=0)})
    private void sendEmptyRequest(NetworkHelper instance, CustomPacketPayload customPacketPayload, Operation<Void> original) {
        PackageOrderRequestPacket packet = new PackageOrderRequestPacket(this.blockEntity.getBlockPos(), GenericOrder.empty(), this.addressBox.getValue(), this.encodeRequester);
        instance.sendToServer((CustomPacketPayload)packet);
    }

    @Overwrite
    public void requestCraftable(CraftableBigItemStack cbis, int requestedDifference) {
        RecipeRequestHelper.requestCraftable((OrderProvider)this, (CraftableGenericStack)CraftableGenericStack.of((CraftableBigItemStack)cbis), (int)requestedDifference);
    }

    public List<BigGenericStack> itemsToOrder() {
        return this.itemsToOrder;
    }

    public List<CraftableGenericStack> recipesToOrder() {
        return this.recipesToOrder;
    }

    public Level world() {
        return this.blockEntity.getLevel();
    }

    public BigGenericStack orderForStack(GenericStack stack) {
        return this.createFactoryLogistics$getOrderForStack(stack);
    }

    public GenericInventorySummary stockSnapshot() {
        return GenericInventorySummary.of((InventorySummary)this.blockEntity.getLastClientsideStockSnapshotAsSummary());
    }

    public List<ItemStack> categories() {
        return ((StockTickerBlockEntityAccessor)this.blockEntity).getCategories();
    }

    public Set<Integer> hiddenCategories() {
        return this.hiddenCategories;
    }

    public List<List<BigGenericStack>> currentItemSource() {
        return this.currentItemSource;
    }
}

