/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.panel.request;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllDataComponents;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.WiFiEffectPacket;
import com.simibubi.create.content.logistics.redstoneRequester.AutoRequestData;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import java.util.UUID;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import ru.zznty.create_factory_abstractions.generic.support.GenericLogisticsManager;
import ru.zznty.create_factory_abstractions.generic.support.GenericOrder;
import ru.zznty.create_factory_logistics.FactoryPackets;
import ru.zznty.create_factory_logistics.mixin.accessor.StockTickerBlockEntityAccessor;

public class PackageOrderRequestPacket
extends BlockEntityConfigurationPacket<StockTickerBlockEntity> {
    private final GenericOrder order;
    private final String address;
    private final boolean encodeRequester;

    public PackageOrderRequestPacket(BlockPos pos, GenericOrder order, String address, boolean encodeRequester) {
        super(pos);
        this.order = order;
        this.address = address;
        this.encodeRequester = encodeRequester;
    }

    protected void applySettings(ServerPlayer player, StockTickerBlockEntity be) {
        if (this.encodeRequester) {
            if (!this.order.isEmpty()) {
                AllSoundEvents.CONFIRM.playOnServer(be.getLevel(), (Vec3i)this.pos);
            }
            player.closeContainer();
            this.program(player, be);
            return;
        }
        if (!this.order.isEmpty()) {
            AllSoundEvents.STOCK_TICKER_REQUEST.playOnServer(be.getLevel(), (Vec3i)this.pos);
            AllAdvancements.STOCK_TICKER.awardTo((Player)player);
            WiFiEffectPacket.send((Level)player.level(), (BlockPos)this.pos);
        }
        GenericLogisticsManager.broadcastPackageRequest((UUID)be.behaviour.freqId, (LogisticallyLinkedBehaviour.RequestType)LogisticallyLinkedBehaviour.RequestType.PLAYER, (GenericOrder)this.order, null, (String)this.address);
        ((StockTickerBlockEntityAccessor)be).setPreviouslyUsedAddress(this.address);
        be.notifyUpdate();
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return FactoryPackets.LOGISTICS_PACKAGE_REQUEST;
    }

    public static void write(RegistryFriendlyByteBuf buf, PackageOrderRequestPacket packet) {
        buf.writeBlockPos(packet.pos);
        packet.order.write(buf);
        buf.writeUtf(packet.address);
        buf.writeBoolean(packet.encodeRequester);
    }

    public static PackageOrderRequestPacket read(RegistryFriendlyByteBuf buf) {
        BlockPos pos = buf.readBlockPos();
        GenericOrder order = GenericOrder.read((RegistryFriendlyByteBuf)buf);
        String address = buf.readUtf();
        boolean encodeRequester = buf.readBoolean();
        return new PackageOrderRequestPacket(pos, order, address, encodeRequester);
    }

    private void program(ServerPlayer player, StockTickerBlockEntity be) {
        ItemStack stack = player.getMainHandItem();
        boolean isRequester = AllBlocks.REDSTONE_REQUESTER.isIn(stack);
        boolean isShopCloth = AllTags.AllItemTags.TABLE_CLOTHS.matches(stack);
        if (!isRequester && !isShopCloth) {
            return;
        }
        if (isRequester) {
            CompoundTag beTag = ((CustomData)stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
            if (beTag.contains("Freq")) {
                return;
            }
            beTag.putUUID("Freq", be.behaviour.freqId);
            beTag.putString("Address", this.address);
            beTag.put("EncodedRequest", (Tag)this.order.write((HolderLookup.Provider)player.level().registryAccess()));
            BlockEntity.addEntityType((CompoundTag)beTag, (BlockEntityType)((BlockEntityType)AllBlockEntityTypes.REDSTONE_REQUESTER.get()));
            stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)beTag));
        } else if (isShopCloth && !stack.has(AllDataComponents.AUTO_REQUEST_DATA)) {
            String targetDim = player.level().dimension().location().toString();
            AutoRequestData autoRequestData = new AutoRequestData(this.order.asCrafting(), this.address, be.getBlockPos(), targetDim, false);
            autoRequestData.writeToItem(BlockPos.ZERO, stack);
        }
        player.setItemInHand(InteractionHand.MAIN_HAND, stack);
    }
}

