/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.panel;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelRenderer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.simibubi.create.foundation.render.RenderTypes;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import ru.zznty.create_factory_logistics.FactoryModels;
import ru.zznty.create_factory_logistics.logistics.panel.FactoryFluidPanelBlockEntity;

public class FactoryFluidPanelRenderer
extends SmartBlockEntityRenderer<FactoryFluidPanelBlockEntity> {
    public FactoryFluidPanelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(FactoryFluidPanelBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        for (FactoryPanelBehaviour behaviour : be.panels.values()) {
            if (!behaviour.isActive()) continue;
            if (behaviour.getAmount() > 0) {
                FactoryFluidPanelRenderer.renderBulb(behaviour, partialTicks, ms, buffer, light, overlay);
            }
            for (FactoryPanelConnection connection : behaviour.targetedBy.values()) {
                FactoryPanelRenderer.renderPath((FactoryPanelBehaviour)behaviour, (FactoryPanelConnection)connection, (float)partialTicks, (PoseStack)ms, (MultiBufferSource)buffer, (int)light, (int)overlay);
            }
            for (FactoryPanelConnection connection : behaviour.targetedByLinks.values()) {
                FactoryPanelRenderer.renderPath((FactoryPanelBehaviour)behaviour, (FactoryPanelConnection)connection, (float)partialTicks, (PoseStack)ms, (MultiBufferSource)buffer, (int)light, (int)overlay);
            }
        }
    }

    public static void renderBulb(FactoryPanelBehaviour behaviour, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = behaviour.blockEntity.getBlockState();
        float xRot = FactoryPanelBlock.getXRot((BlockState)blockState) + 1.5707964f;
        float yRot = FactoryPanelBlock.getYRot((BlockState)blockState);
        float glow = behaviour.bulb.getValue(partialTicks);
        boolean missingAddress = behaviour.isMissingAddress();
        PartialModel partial = behaviour.redstonePowered || missingAddress ? FactoryModels.FACTORY_FLUID_PANEL_RED_LIGHT : FactoryModels.FACTORY_FLUID_PANEL_LIGHT;
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)partial, (BlockState)blockState).rotateCentered(yRot, Direction.UP)).rotateCentered(xRot, Direction.EAST)).rotateCentered((float)Math.PI, Direction.UP)).translate((double)behaviour.slot.xOffset * 0.5, 0.0, (double)behaviour.slot.yOffset * 0.5)).light(glow > 0.125f ? 0xF000F0 : light).overlay(overlay).renderInto(ms, buffer.getBuffer(RenderType.translucent()));
        if (glow < 0.125f) {
            return;
        }
        glow = (float)(1.0 - 2.0 * Math.pow(glow - 0.75f, 2.0));
        glow = Mth.clamp((float)glow, (float)-1.0f, (float)1.0f);
        int color = (int)(200.0f * glow);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)partial, (BlockState)blockState).rotateCentered(yRot, Direction.UP)).rotateCentered(xRot, Direction.EAST)).rotateCentered((float)Math.PI, Direction.UP)).translate((double)behaviour.slot.xOffset * 0.5, 0.0, (double)behaviour.slot.yOffset * 0.5)).light(0xF000F0).color(color, color, color, 255).overlay(overlay).renderInto(ms, buffer.getBuffer(RenderTypes.additive()));
    }
}

