/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.networkLink;

import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import ru.zznty.create_factory_logistics.FactoryBlockEntities;

public class NetworkLinkBlockItem
extends LogisticallyLinkedBlockItem {
    public NetworkLinkBlockItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public boolean isFoil(ItemStack pStack) {
        return NetworkLinkBlockItem.isTuned(pStack);
    }

    public static boolean isTuned(ItemStack pStack) {
        return ((CustomData)pStack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).contains("Freq");
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext tooltipContext, List<Component> pTooltip, TooltipFlag pFlag) {
        super.appendHoverText(pStack, tooltipContext, pTooltip, pFlag);
        CustomData tag = (CustomData)pStack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY);
        if (!tag.contains("ingredient_type")) {
            return;
        }
        ResourceLocation ingredientType = ResourceLocation.parse((String)tag.copyTag().getString("ingredient_type"));
        if (ingredientType.getPath().equals("empty")) {
            return;
        }
        CreateLang.builder((String)ingredientType.getNamespace()).add(CreateLang.builder((String)"create_factory_logistics").translate("gui.ingredient_type_qualified_item", new Object[0])).space().translate("gui.ingredient_type." + ingredientType.getPath(), new Object[0]).style(ChatFormatting.ITALIC).addTo(pTooltip);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        ItemStack stack = pContext.getItemInHand();
        BlockPos pos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        Player player = pContext.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (player.isShiftKeyDown()) {
            return super.useOn(pContext);
        }
        LogisticallyLinkedBehaviour link = (LogisticallyLinkedBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, (BehaviourType)LogisticallyLinkedBehaviour.TYPE);
        boolean tuned = NetworkLinkBlockItem.isTuned(stack);
        if (link != null) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (!link.mayInteractMessage(player)) {
                return InteractionResult.SUCCESS;
            }
            NetworkLinkBlockItem.assignFrequency(stack, player, link.freqId);
            return InteractionResult.SUCCESS;
        }
        InteractionResult useOn = super.useOn(pContext);
        if (level.isClientSide || useOn == InteractionResult.FAIL) {
            return useOn;
        }
        player.displayClientMessage((Component)(tuned ? CreateLang.translateDirect((String)"logistically_linked.connected", (Object[])new Object[0]) : CreateLang.translateDirect((String)"logistically_linked.new_network_started", (Object[])new Object[0])), true);
        return useOn;
    }

    public static void assignFrequency(ItemStack stack, Player player, UUID frequency) {
        CustomData.update((DataComponentType)DataComponents.BLOCK_ENTITY_DATA, (ItemStack)stack, t -> {
            BlockEntity.addEntityType((CompoundTag)t, (BlockEntityType)((BlockEntityType)FactoryBlockEntities.NETWORK_LINK.get()));
            t.putUUID("Freq", frequency);
        });
        player.displayClientMessage((Component)CreateLang.translateDirect((String)"logistically_linked.tuned", (Object[])new Object[0]), true);
    }
}

