/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.networkLink;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKeyRegistration;
import ru.zznty.create_factory_abstractions.generic.impl.GenericContentExtender;
import ru.zznty.create_factory_logistics.logistics.networkLink.NetworkLinkBlock;
import ru.zznty.create_factory_logistics.logistics.networkLink.NetworkLinkMode;

public class NetworkLinkBlockEntity
extends SmartBlockEntity {
    private LogisticallyLinkedBehaviour link;
    @Nullable
    private GenericKeyRegistration registration;
    private ScrollOptionBehaviour<NetworkLinkMode> scroll;

    public NetworkLinkBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.link = new LogisticallyLinkedBehaviour((SmartBlockEntity)this, false);
        behaviours.add((BlockEntityBehaviour)this.link);
        this.scroll = new ScrollOptionBehaviour(NetworkLinkMode.class, (Component)Component.translatable((String)"create_factory_logistics.gui.network_link.mode"), (SmartBlockEntity)this, (ValueBoxTransform)new ValueBox());
        behaviours.add((BlockEntityBehaviour)this.scroll);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        if (tag.contains("ingredient_type", 8)) {
            this.registration = (GenericKeyRegistration)GenericContentExtender.REGISTRY.get(ResourceLocation.parse((String)tag.getString("ingredient_type")));
        }
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        if (this.registration != null) {
            tag.putString("ingredient_type", Objects.requireNonNull(GenericContentExtender.REGISTRY.getKey((Object)this.registration)).toString());
        }
    }

    public NetworkLinkMode mode() {
        return (NetworkLinkMode)this.scroll.get();
    }

    public GenericKeyRegistration provider() {
        return this.registration;
    }

    private static class ValueBox
    extends ValueBoxTransform.Sided {
        private ValueBox() {
        }

        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
            float yRot = AngleHelper.horizontalAngle((Direction)(state.getValue((Property)NetworkLinkBlock.FACE) == AttachFace.FLOOR ? (Direction)state.getValue((Property)NetworkLinkBlock.FACING) : this.getSide().getOpposite()));
            float xRot = AngleHelper.verticalAngle((Direction)this.getSide().getOpposite());
            ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees(yRot)).rotateXDegrees(xRot);
        }

        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            Vec3 location;
            if (state.getValue((Property)NetworkLinkBlock.FACE) == AttachFace.FLOOR) {
                location = VecHelper.voxelSpace((double)8.0, (double)6.0, (double)5.0);
                location = VecHelper.rotateCentered((Vec3)location, (double)AngleHelper.horizontalAngle((Direction)((Direction)state.getValue((Property)NetworkLinkBlock.FACING))), (Direction.Axis)Direction.Axis.Y);
            } else {
                location = VecHelper.voxelSpace((double)8.0, (double)5.0, (double)6.0);
                location = VecHelper.rotateCentered((Vec3)location, (double)AngleHelper.verticalAngle((Direction)this.getSide()), (Direction.Axis)Direction.Axis.X);
            }
            location = VecHelper.rotateCentered((Vec3)location, (double)AngleHelper.horizontalAngle((Direction)this.getSide()), (Direction.Axis)Direction.Axis.Y);
            return location;
        }

        protected Vec3 getSouthLocation() {
            return null;
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            if (state.getValue((Property)NetworkLinkBlock.FACE) == AttachFace.FLOOR) {
                return direction == Direction.UP;
            }
            return state.getValue((Property)NetworkLinkBlock.FACING) == direction;
        }
    }
}

