/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.networkLink;

import com.simibubi.create.foundation.item.ItemHelper;
import java.util.UUID;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKey;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.generic.key.item.ItemKey;
import ru.zznty.create_factory_logistics.logistics.networkLink.BaseNetworkHandler;
import ru.zznty.create_factory_logistics.logistics.networkLink.NetworkLinkMode;

public class NetworkItemHandler
extends BaseNetworkHandler
implements IItemHandler {
    public NetworkItemHandler(UUID network, NetworkLinkMode mode) {
        super(network, mode);
    }

    public int getSlots() {
        return this.summary().size();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return NetworkItemHandler.asItem(this.summary().get(slot));
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE - 1 / this.getSlots();
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return ItemHelper.canItemStackAmountsStack((ItemStack)NetworkItemHandler.asItem(this.summary().get(slot)), (ItemStack)stack);
    }

    private static ItemStack asItem(GenericStack stack) {
        GenericKey genericKey = stack.key();
        if (genericKey instanceof ItemKey) {
            ItemKey itemKey = (ItemKey)genericKey;
            return itemKey.stack().copyWithCount(stack.amount());
        }
        return ItemStack.EMPTY;
    }
}

