/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.generic;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_logistics.logistics.generic.GenericAttribute;

public interface GenericAttributeType
extends ItemAttributeType {
    @NotNull
    public GenericAttribute create();

    public List<ItemAttribute> getAllAttributes(GenericStack var1, Level var2);

    @NotNull
    default public ItemAttribute createAttribute() {
        return this.create();
    }

    default public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
        return this.getAllAttributes(GenericStack.wrap((ItemStack)stack), level);
    }

    default public MapCodec<? extends GenericAttribute> codec() {
        return new Codec<GenericAttribute>(){

            public <T> DataResult<T> encode(GenericAttribute input, DynamicOps<T> ops, T prefix) {
                CompoundTag tag = new CompoundTag();
                HolderLookup.Provider registries = ((RegistryOps.HolderLookupAdapter)((RegistryOps)ops).lookupProvider).lookupProvider;
                input.save(registries, tag);
                return CompoundTag.CODEC.encode((Object)tag, ops, prefix);
            }

            public <T> DataResult<Pair<GenericAttribute, T>> decode(DynamicOps<T> ops, T input) {
                CompoundTag tag = (CompoundTag)((Pair)CompoundTag.CODEC.decode(ops, input).getOrThrow()).getFirst();
                GenericAttribute attribute = GenericAttributeType.this.create();
                HolderLookup.Provider registries = ((RegistryOps.HolderLookupAdapter)((RegistryOps)ops).lookupProvider).lookupProvider;
                attribute.load(registries, tag);
                return DataResult.success((Object)Pair.of((Object)attribute, input));
            }

            public String toString() {
                return "GenericAttributeType";
            }
        }.fieldOf("data");
    }

    default public StreamCodec<? super RegistryFriendlyByteBuf, ? extends GenericAttribute> streamCodec() {
        return StreamCodec.ofMember((attribute, buf) -> {
            CompoundTag nbt = new CompoundTag();
            attribute.save((HolderLookup.Provider)buf.registryAccess(), nbt);
            buf.writeNbt((Tag)nbt);
        }, buf -> {
            CompoundTag nbt = buf.readNbt();
            GenericAttribute attribute = this.create();
            attribute.load((HolderLookup.Provider)buf.registryAccess(), nbt);
            return attribute;
        });
    }
}

