/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.generic;

import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.List;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKey;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_logistics.FactoryGenericAttributeTypes;
import ru.zznty.create_factory_logistics.logistics.generic.FluidGenericAttribute;
import ru.zznty.create_factory_logistics.logistics.generic.FluidKey;
import ru.zznty.create_factory_logistics.logistics.generic.GenericAttribute;
import ru.zznty.create_factory_logistics.logistics.generic.GenericAttributeType;

public class FluidNoNbtGenericAttribute
extends FluidGenericAttribute {
    public FluidNoNbtGenericAttribute(@Nullable FluidKey fluid) {
        super(fluid);
    }

    @Override
    public boolean appliesTo(GenericStack stack, Level world) {
        if (this.fluid == null) {
            return false;
        }
        GenericKey genericKey = stack.key();
        if (!(genericKey instanceof FluidKey)) {
            return false;
        }
        FluidKey fluidKey = (FluidKey)genericKey;
        return this.fluid.fluid().equals(fluidKey.fluid());
    }

    @Override
    public ItemAttributeType getType() {
        return (ItemAttributeType)FactoryGenericAttributeTypes.IS_FLUID_NO_NBT.get();
    }

    @Override
    public String getTranslationKey() {
        return "is_fluid_no_nbt";
    }

    protected static List<FluidKey> extractUniqueFluids(GenericStack stack, Level level) {
        List<FluidKey> fluids = FluidNoNbtGenericAttribute.extractFluids(stack, level);
        return fluids.stream().filter(f -> !f.nbt().isEmpty()).map(f -> new FluidKey(f.fluid(), new PatchedDataComponentMap(DataComponentMap.EMPTY))).distinct().toList();
    }

    public static class Type
    implements GenericAttributeType {
        @Override
        @NotNull
        public GenericAttribute create() {
            return new FluidNoNbtGenericAttribute(null);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(GenericStack stack, Level level) {
            return FluidNoNbtGenericAttribute.extractUniqueFluids(stack, level).stream().map(FluidNoNbtGenericAttribute::new).toList();
        }
    }
}

