/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.generic;

import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKey;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKeyRegistration;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKeySerializer;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.generic.impl.GenericContentExtender;
import ru.zznty.create_factory_abstractions.generic.key.item.ItemKey;
import ru.zznty.create_factory_logistics.FactoryGenericAttributeTypes;
import ru.zznty.create_factory_logistics.logistics.generic.FluidKey;
import ru.zznty.create_factory_logistics.logistics.generic.GenericAttribute;
import ru.zznty.create_factory_logistics.logistics.generic.GenericAttributeType;

public class FluidGenericAttribute
implements GenericAttribute {
    @Nullable
    protected FluidKey fluid;

    public FluidGenericAttribute(@Nullable FluidKey fluid) {
        this.fluid = fluid;
    }

    @Override
    public boolean appliesTo(GenericStack stack, Level world) {
        if (this.fluid == null) {
            return false;
        }
        GenericKey genericKey = stack.key();
        if (!(genericKey instanceof FluidKey)) {
            return false;
        }
        FluidKey fluidKey = (FluidKey)genericKey;
        return this.fluid.equals(fluidKey);
    }

    public ItemAttributeType getType() {
        return (ItemAttributeType)FactoryGenericAttributeTypes.IS_FLUID.get();
    }

    @Override
    public void save(HolderLookup.Provider registries, CompoundTag nbt) {
        if (this.fluid == null) {
            return;
        }
        ((GenericKeyRegistration)GenericContentExtender.REGISTRATIONS.get(FluidKey.class)).serializer().write((GenericKey)this.fluid, registries, nbt);
    }

    @Override
    public void load(HolderLookup.Provider registries, CompoundTag nbt) {
        GenericKeySerializer serializer = ((GenericKeyRegistration)GenericContentExtender.REGISTRATIONS.get(FluidKey.class)).serializer();
        this.fluid = (FluidKey)serializer.read(registries, nbt);
        if (this.fluid.fluid() == Fluids.EMPTY) {
            this.fluid = null;
        }
    }

    public String getTranslationKey() {
        return "is_fluid";
    }

    public Object[] getTranslationParameters() {
        String parameter = "";
        if (this.fluid != null) {
            FluidType fluidType = ((Fluid)this.fluid.fluid().value()).getFluidType();
            parameter = this.fluid.nbt().isEmpty() ? fluidType.getDescription().getString() : fluidType.getDescription(this.fluid.stack()).getString();
        }
        return new Object[]{parameter};
    }

    protected static List<FluidKey> extractFluids(GenericStack stack, Level level) {
        GenericKey genericKey = stack.key();
        if (genericKey instanceof FluidKey) {
            FluidKey fluidKey = (FluidKey)genericKey;
            return List.of(fluidKey);
        }
        genericKey = stack.key();
        if (!(genericKey instanceof ItemKey)) {
            return List.of();
        }
        ItemKey itemKey = (ItemKey)genericKey;
        Optional fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemKey.stack());
        if (fluidHandler.isPresent()) {
            ArrayList<FluidKey> attributes = new ArrayList<FluidKey>();
            IFluidHandlerItem handlerItem = (IFluidHandlerItem)fluidHandler.get();
            for (int i = 0; i < handlerItem.getTanks(); ++i) {
                FluidStack fluidInItem = handlerItem.getFluidInTank(i);
                if (fluidInItem.getFluid() == Fluids.EMPTY) continue;
                attributes.add(new FluidKey((Holder<Fluid>)fluidInItem.getFluidHolder(), fluidInItem.getComponents()));
            }
            return attributes;
        }
        Pair emptyResult = GenericItemEmptying.emptyItem((Level)level, (ItemStack)itemKey.stack(), (boolean)true);
        FluidStack resultFluid = (FluidStack)emptyResult.getFirst();
        if (resultFluid.isEmpty()) {
            return List.of();
        }
        return List.of(new FluidKey((Holder<Fluid>)resultFluid.getFluidHolder(), resultFluid.getComponents()));
    }

    public int hashCode() {
        return this.fluid == null ? 0 : this.fluid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FluidGenericAttribute) {
            FluidGenericAttribute that = (FluidGenericAttribute)obj;
            return Objects.equals(this.fluid, that.fluid);
        }
        return false;
    }

    public static class Type
    implements GenericAttributeType {
        @Override
        @NotNull
        public GenericAttribute create() {
            return new FluidGenericAttribute(null);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(GenericStack stack, Level level) {
            return FluidGenericAttribute.extractFluids(stack, level).stream().map(FluidGenericAttribute::new).toList();
        }
    }
}

