/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.composite;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.logistics.box.PackageEntity;
import com.simibubi.create.content.logistics.chute.ChuteBlock;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import ru.zznty.create_factory_logistics.FactoryEntities;
import ru.zznty.create_factory_logistics.logistics.composite.CompositePackageItem;
import ru.zznty.create_factory_logistics.mixin.accessor.PackageEntityAccessor;

public class CompositePackageEntity
extends PackageEntity
implements IHaveGoggleInformation {
    public List<ItemStack> children = List.of();

    public CompositePackageEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public CompositePackageEntity(Level worldIn, double x, double y, double z) {
        this((EntityType)FactoryEntities.COMPOSITE_PACKAGE.get(), worldIn);
        this.setPos(x, y, z);
        this.refreshDimensions();
    }

    public void setBox(ItemStack box) {
        super.setBox(box);
        this.children = CompositePackageItem.getChildren((HolderLookup.Provider)this.level().registryAccess(), box);
    }

    protected void dropAllDeathLoot(ServerLevel level, DamageSource pDamageSource) {
        super.dropAllDeathLoot(level, pDamageSource);
        for (ItemStack child : this.children) {
            ItemEntity jarEntity = new ItemEntity((Level)level, this.position().x, this.position().y, this.position().z, child);
            level.addFreshEntity((Entity)jarEntity);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip);
    }

    private boolean containedFluidTooltip(List<Component> originalTooltip) {
        ArrayList tooltip = new ArrayList();
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        CreateLang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        boolean isEmpty = true;
        for (ItemStack child : this.children) {
            FluidStack fluidStack;
            Optional fluidHandler = FluidUtil.getFluidHandler((ItemStack)child);
            if (fluidHandler.isEmpty() || (fluidStack = ((IFluidHandlerItem)fluidHandler.get()).getFluidInTank(0)).isEmpty()) continue;
            CreateLang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            CreateLang.builder().add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)((IFluidHandlerItem)fluidHandler.get()).getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (isEmpty) {
            tooltip.clear();
        }
        originalTooltip.addAll(tooltip);
        return true;
    }

    public static PackageEntity fromDroppedItem(Level world, Entity originalEntity, ItemStack itemstack) {
        PackageEntity packageEntity = (PackageEntity)((EntityType)FactoryEntities.COMPOSITE_PACKAGE.get()).create(world);
        Vec3 position = originalEntity.position();
        packageEntity.setPos(position);
        packageEntity.setBox(itemstack);
        packageEntity.setDeltaMovement(originalEntity.getDeltaMovement().scale(1.5));
        PackageEntityAccessor accessor = (PackageEntityAccessor)packageEntity;
        accessor.setOriginalEntity(originalEntity);
        if (world != null && !world.isClientSide && ChuteBlock.isChute((BlockState)world.getBlockState(BlockPos.containing((double)position.x, (double)(position.y + 0.5), (double)position.z)))) {
            packageEntity.setYRot((float)((int)packageEntity.getYRot() / 90 * 90));
        }
        return packageEntity;
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> boxBuilder = builder;
        return boxBuilder.sized(1.0f, 1.0f);
    }
}

