/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util;

import com.mojang.serialization.Codec;
import java.util.Locale;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SplashPotionItem;
import org.jetbrains.annotations.Nullable;

public enum PotionBottleType implements StringRepresentable
{
    REGULAR("item.minecraft.potion"),
    SPLASH("item.minecraft.splash_potion"),
    LINGERING("item.minecraft.lingering_potion");

    private final String name = this.name().toLowerCase(Locale.ROOT);
    private final Component translatedName;
    public static final Codec<PotionBottleType> CODEC;

    private PotionBottleType(String translatedKey) {
        this.translatedName = Component.translatable((String)translatedKey);
    }

    public ItemStack getDefaultItem() {
        return (switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Items.POTION;
            case 2 -> Items.LINGERING_POTION;
            case 1 -> Items.SPLASH_POTION;
        }).getDefaultInstance();
    }

    public Component getTranslatedName() {
        return this.translatedName;
    }

    public String getSerializedName() {
        return this.name;
    }

    @Nullable
    public static PotionBottleType get(Item potionItem) {
        if (potionItem instanceof SplashPotionItem) {
            return SPLASH;
        }
        if (potionItem instanceof LingeringPotionItem) {
            return LINGERING;
        }
        if (potionItem instanceof PotionItem) {
            return REGULAR;
        }
        return null;
    }

    public static PotionBottleType getOrDefault(Item filledContainer) {
        PotionBottleType type = PotionBottleType.get(filledContainer);
        return type != null ? type : REGULAR;
    }

    public static PotionBottleType getOrDefault(SoftFluidStack stack) {
        return (PotionBottleType)((Object)stack.getOrDefault(MoonlightRegistry.BOTTLE_TYPE.get(), (Object)REGULAR));
    }

    static {
        CODEC = StringRepresentable.fromValues(PotionBottleType::values);
    }
}

