/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Stopwatch;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.AbstractCachedEditableResources;
import net.mehvahdjukaar.moonlight.api.resources.pack.FastSearchPathPackResources;
import net.mehvahdjukaar.moonlight.core.CommonConfigs;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import org.apache.commons.io.FileUtils;

public class CachePathPackResources
extends AbstractCachedEditableResources {
    public CachePathPackResources(PackLocationInfo location, PackType type, Path path) {
        super(path, location, type, (Component)Component.translatable((String)"message.moonlight.cached"));
    }

    @Override
    public void addResource(ResourceLocation id, byte[] bytes) {
        RPUtils.writeResource(id, bytes, this.path, this.packType);
    }

    @Override
    public void removeResource(ResourceLocation id) {
        Path resPath = RPUtils.getResourcePath(this.path, id, this.packType);
        try {
            FileUtils.deleteDirectory((File)resPath.toFile());
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to delete resource {}", (Object)id, (Object)e);
        }
    }

    @Override
    public void removeRootResource(String name) {
    }

    @Override
    public boolean clearAllResources() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            FileUtils.deleteDirectory((File)this.path.toFile());
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to clear cache pack resources at {}", (Object)this.path, (Object)e);
        }
        Moonlight.LOGGER.info("Cleared cache pack resources at {} in {}", (Object)this.path, (Object)stopwatch);
        return true;
    }

    @Override
    public boolean initializeIfValid() {
        boolean dirExists = Files.isDirectory(this.path, new LinkOption[0]);
        if (dirExists) {
            this.cachedResources = CommonConfigs.FASTER_CACHE_SEARCH.get() != false ? new FastSearchPathPackResources(this.locationInfo, this.path, this.packType) : new PathPackResources.PathResourcesSupplier(this.path).openPrimary(this.locationInfo);
        }
        return dirExists;
    }

    @Override
    public void commitChanges() {
        this.initializeIfValid();
    }

    @Override
    public PackType getPackType() {
        return this.packType;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

