/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.chloride.impl.sodium.pages;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.shaders.FogShape;
import java.util.ArrayList;
import me.srrapero720.chloride.ChlorideConfig;
import me.srrapero720.chloride.impl.ChunkFade;
import me.srrapero720.chloride.impl.LeavesCulling;
import me.srrapero720.chloride.impl.sodium.SodiumFeatures;
import me.srrapero720.chloride.impl.sodium.controls.BetterCyclingControl;
import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.OptionFlag;
import net.caffeinemc.mods.sodium.client.gui.options.OptionGroup;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpact;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpl;
import net.caffeinemc.mods.sodium.client.gui.options.OptionPage;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlValueFormatter;
import net.caffeinemc.mods.sodium.client.gui.options.control.CyclingControl;
import net.caffeinemc.mods.sodium.client.gui.options.control.SliderControl;
import net.caffeinemc.mods.sodium.client.gui.options.control.TickBoxControl;
import net.minecraft.network.chat.Component;

public class WorldPage
extends OptionPage {
    public WorldPage() {
        super((Component)Component.translatable((String)"chloride.world"), WorldPage.create());
    }

    private static ImmutableList<OptionGroup> create() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        OptionGroup.Builder band = OptionGroup.createBuilder();
        band.add((Option)OptionImpl.createBuilder(Boolean.TYPE, SodiumFeatures.STORAGE).setName((Component)Component.translatable((String)"chloride.world.blueband.title")).setTooltip((Component)Component.translatable((String)"chloride.world.blueband.desc")).setControl(TickBoxControl::new).setBinding((opt, v) -> {
            ChlorideConfig.blueBand = v;
        }, opt -> ChlorideConfig.blueBand).build());
        OptionGroup.Builder customFog = OptionGroup.createBuilder();
        customFog.add((Option)OptionImpl.createBuilder(Boolean.TYPE, SodiumFeatures.STORAGE).setName((Component)Component.translatable((String)"chloride.world.fog.title")).setTooltip((Component)Component.translatable((String)"chloride.world.fog.desc")).setControl(TickBoxControl::new).setBinding((opt, value) -> {
            ChlorideConfig.fog = value;
        }, opt -> ChlorideConfig.fog).setImpact(OptionImpact.LOW).build());
        customFog.add((Option)OptionImpl.createBuilder(Boolean.TYPE, SodiumFeatures.STORAGE).setName((Component)Component.translatable((String)"chloride.world.custom_fog.title")).setTooltip((Component)Component.translatable((String)"chloride.world.custom_fog.desc")).setControl(TickBoxControl::new).setBinding((opt, value) -> {
            ChlorideConfig.customFog = value;
        }, opt -> ChlorideConfig.customFog).setImpact(OptionImpact.LOW).build());
        customFog.add((Option)OptionImpl.createBuilder(Integer.TYPE, SodiumFeatures.STORAGE).setName((Component)Component.translatable((String)"chloride.world.custom_fog.start.title")).setTooltip((Component)Component.translatable((String)"chloride.world.custom_fog.start.desc")).setControl(option -> new SliderControl((Option)option, -1000, 1000, 10, ControlValueFormatter.number())).setBinding((options, current) -> {
            ChlorideConfig.fogStart = current;
        }, options -> ChlorideConfig.fogStart).build());
        customFog.add((Option)OptionImpl.createBuilder(Integer.TYPE, SodiumFeatures.STORAGE).setName((Component)Component.translatable((String)"chloride.world.custom_fog.end.title")).setTooltip((Component)Component.translatable((String)"chloride.world.custom_fog.end.desc")).setControl(option -> new SliderControl((Option)option, 100, 10000, 50, ControlValueFormatter.number())).setBinding((options, current) -> {
            ChlorideConfig.fogEnd = current;
        }, options -> ChlorideConfig.fogEnd).build());
        customFog.add((Option)OptionImpl.createBuilder(FogShape.class, SodiumFeatures.STORAGE).setName((Component)Component.translatable((String)"chloride.world.custom_fog.shape.title")).setTooltip((Component)Component.translatable((String)"chloride.world.custom_fog.shape.desc")).setControl(option -> new CyclingControl((Option)option, FogShape.class, BetterCyclingControl.tEnumComponent("chloride.world.custom_fog.shape", FogShape.class))).setBinding((opts, value) -> {
            ChlorideConfig.fogShape = value;
        }, opts -> ChlorideConfig.fogShape).build());
        OptionGroup.Builder worldVisuals = OptionGroup.createBuilder();
        worldVisuals.add((Option)OptionImpl.createBuilder(LeavesCulling.LeavesCullingMode.class, SodiumFeatures.STORAGE).setName((Component)Component.translatable((String)"chloride.world.leaves_culling.title")).setTooltip((Component)Component.translatable((String)"chloride.world.leaves_culling.desc")).setControl(opt -> new CyclingControl((Option)opt, LeavesCulling.LeavesCullingMode.class, BetterCyclingControl.tEnumComponent("chloride.world.leaves_culling", LeavesCulling.LeavesCullingMode.class))).setBinding((opt, v) -> {
            ChlorideConfig.leavesCulling = v;
        }, opts -> ChlorideConfig.leavesCulling).setImpact(OptionImpact.HIGH).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_RENDERER_RELOAD}).build());
        worldVisuals.add((Option)OptionImpl.createBuilder(Integer.TYPE, SodiumFeatures.STORAGE).setName((Component)Component.translatable((String)"chloride.world.clouds.height.title")).setTooltip((Component)Component.translatable((String)"chloride.world.clouds.height.desc")).setControl(opt -> new SliderControl((Option)opt, 64, 364, 4, ControlValueFormatter.biomeBlend())).setBinding((opt, value) -> {
            ChlorideConfig.cloudsHeight = value;
        }, opt -> ChlorideConfig.cloudsHeight).build());
        OptionGroup.Builder worldAmazings = OptionGroup.createBuilder();
        worldAmazings.add((Option)OptionImpl.createBuilder(ChunkFade.Speed.class, SodiumFeatures.STORAGE).setName((Component)Component.translatable((String)"chloride.world.fade.title")).setTooltip((Component)Component.translatable((String)"chloride.world.fade.desc")).setControl(option -> new CyclingControl((Option)option, ChunkFade.Speed.class, new Component[]{Component.translatable((String)"options.off"), Component.translatable((String)"options.graphics.fast"), Component.translatable((String)"options.graphics.fancy")})).setBinding((opts, value) -> {
            ChlorideConfig.chunkFadeSpeed = value;
        }, opts -> ChlorideConfig.chunkFadeSpeed).setImpact(OptionImpact.LOW).setEnabled(() -> false).build());
        groups.add(band.build());
        groups.add(customFog.build());
        groups.add(worldVisuals.build());
        groups.add(worldAmazings.build());
        return ImmutableList.copyOf(groups);
    }
}

