/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.chloride.impl;

import java.nio.file.Path;
import java.util.Optional;
import me.srrapero720.chloride.Chloride;
import me.srrapero720.chloride.api.events.FastModelSettingsUpdate;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.BuiltInPackSource;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddPackFindersEvent;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME, modid="chloride")
public class FastBlocks {
    public static Pack SOLID_BEDS_PACK;
    public static Pack SOLID_CHESTS_PACK;

    public static boolean canUseOnChests() {
        return !Chloride.installed("enhancedblockentities");
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onChestSettingUpdateEvent(FastModelSettingsUpdate.ChestEvent e) {
        if (e.isEnabled()) {
            Minecraft.getInstance().getResourcePackRepository().addPack(SOLID_CHESTS_PACK.getId());
        } else {
            Minecraft.getInstance().getResourcePackRepository().removePack(SOLID_CHESTS_PACK.getId());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBedSettingUpdateEvent(FastModelSettingsUpdate.BedEvent e) {
        if (e.isEnabled()) {
            Minecraft.getInstance().getResourcePackRepository().addPack(SOLID_BEDS_PACK.getId());
        } else {
            Minecraft.getInstance().getResourcePackRepository().removePack(SOLID_BEDS_PACK.getId());
        }
    }

    private static PathPackResources getPathResources(PackLocationInfo info, Path path) {
        return new PathPackResources(info, path){

            public boolean isHidden() {
                return false;
            }
        };
    }

    @EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD, modid="chloride")
    public static final class ModEvents {
        @SubscribeEvent
        public static void registerResourcePacks(AddPackFindersEvent e) {
            Chloride.LOGGER.info("Registering CHLORIDE built-in packs");
            if (e.getPackType() == PackType.CLIENT_RESOURCES) {
                ModContainer modFile = (ModContainer)ModList.get().getModContainerById("chloride").get();
                Path bedsPath = modFile.getModInfo().getOwningFile().getFile().findResource(new String[]{"custom_packs/solid_beds"});
                SOLID_BEDS_PACK = Pack.readMetaAndCreate((PackLocationInfo)new PackLocationInfo("chloride_solid_beds", (Component)Component.literal((String)"Chloride: Solid Beds"), PackSource.BUILT_IN, Optional.of(new KnownPack("chloride", "solid_beds", "1.0.0"))), (Pack.ResourcesSupplier)BuiltInPackSource.fromName(path -> FastBlocks.getPathResources(path, bedsPath)), (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(false, Pack.Position.TOP, true));
                Path chestsPath = modFile.getModInfo().getOwningFile().getFile().findResource(new String[]{"custom_packs/solid_chests"});
                SOLID_CHESTS_PACK = Pack.readMetaAndCreate((PackLocationInfo)new PackLocationInfo("chloride_solid_chests", (Component)Component.literal((String)"Chloride: Solid Chests"), PackSource.BUILT_IN, Optional.of(new KnownPack("chloride", "solid_beds", "1.0.0"))), (Pack.ResourcesSupplier)BuiltInPackSource.fromName(path -> FastBlocks.getPathResources(path, chestsPath)), (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(false, Pack.Position.TOP, true));
                e.addRepositorySource(consumer -> {
                    consumer.accept(SOLID_BEDS_PACK);
                    consumer.accept(SOLID_CHESTS_PACK);
                });
            }
        }
    }
}

