/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.chloride.impl;

import com.mojang.blaze3d.platform.Window;
import me.srrapero720.chloride.ChlorideConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;

public class Borderless {
    public static void setFullScreenMode(Mode value) {
        Minecraft client = Minecraft.getInstance();
        Options opts = client.options;
        ChlorideConfig.fullScreen = value;
        opts.fullscreen().set((Object)(value != Mode.WINDOWED ? 1 : 0));
        Window window = client.getWindow();
        if (window.isFullscreen() != ((Boolean)opts.fullscreen().get()).booleanValue()) {
            window.toggleFullScreen();
            opts.fullscreen().set((Object)window.isFullscreen());
        }
        if (((Boolean)opts.fullscreen().get()).booleanValue()) {
            window.dirty = true;
            window.changeFullscreenVideoMode();
        }
    }

    public static enum Mode {
        WINDOWED,
        BORDERLESS,
        FULLSCREEN;


        public static Mode nextOf(Mode current) {
            return switch (current.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> BORDERLESS;
                case 1 -> FULLSCREEN;
                case 2 -> WINDOWED;
            };
        }

        public static Mode nextBorderless(Mode current) {
            return switch (current.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1, 2 -> WINDOWED;
                case 0 -> BORDERLESS;
            };
        }

        public static Mode nextFullscreen(Mode current) {
            return switch (current.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1, 2 -> WINDOWED;
                case 0 -> FULLSCREEN;
            };
        }

        public static Mode getVanillaConfig() {
            return (Boolean)Minecraft.getInstance().options.fullscreen().get() != false ? BORDERLESS : WINDOWED;
        }

        public boolean isBorderless() {
            return this == BORDERLESS;
        }
    }

    public static enum AttachMode {
        ATTACH,
        REPLACE,
        OFF;

    }
}

