/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegexTokenizer {
    private final String pattern;
    private int pos = 0;
    @Nullable
    private Node parsed;

    public RegexTokenizer(String pattern) {
        this.pattern = Objects.requireNonNull(pattern);
    }

    @NotNull
    public static Node parse(String pattern) throws PatternSyntaxException {
        return new RegexTokenizer(pattern).parse();
    }

    public static boolean visitNodes(Node node, Predicate<Node> predicate) {
        if (predicate.test(node)) {
            return true;
        }
        List<Node> children = node.getChildren();
        if (children != null) {
            return children.stream().anyMatch(x -> RegexTokenizer.visitNodes(x, predicate));
        }
        return false;
    }

    @NotNull
    public Node parse() throws PatternSyntaxException {
        if (this.parsed == null) {
            this.parsed = this.parseAlternation();
            if (!this.eof()) {
                throw this.error("Unexpected character after end of expression");
            }
        }
        return this.parsed;
    }

    private boolean eof() {
        return this.pos >= this.pattern.length();
    }

    private char peek() {
        return this.peek(0);
    }

    private char peek(int ahead) {
        int p = this.pos + ahead;
        return p < this.pattern.length() ? this.pattern.charAt(p) : (char)'\u0000';
    }

    private char consume() {
        if (this.eof()) {
            return '\u0000';
        }
        return this.pattern.charAt(this.pos++);
    }

    private boolean consumeIf(char c) {
        if (!this.eof() && this.pattern.charAt(this.pos) == c) {
            ++this.pos;
            return true;
        }
        return false;
    }

    private String readMatching(Predicate<Character> matcher) {
        int start = this.pos;
        while (!this.eof() && matcher.test(Character.valueOf(this.peek()))) {
            ++this.pos;
        }
        return this.pattern.substring(start, this.pos);
    }

    private String readMatching(Predicate<Character> matcher, int maxLength) {
        int start = this.pos;
        while (!this.eof() && this.pos - start < maxLength && matcher.test(Character.valueOf(this.peek()))) {
            ++this.pos;
        }
        return this.pattern.substring(start, this.pos);
    }

    private PatternSyntaxException error(String msg) {
        return new PatternSyntaxException(msg, this.pattern, this.pos);
    }

    @NotNull
    private Node parseAlternation() throws PatternSyntaxException {
        ArrayList<Node> branches = new ArrayList<Node>();
        branches.add(this.parseSequence());
        while (this.consumeIf('|')) {
            branches.add(this.parseSequence());
        }
        if (branches.size() == 1) {
            return (Node)branches.getFirst();
        }
        return new AlternationNode(branches);
    }

    private Node parseSequence() throws PatternSyntaxException {
        char c;
        ArrayList<Node> sequence = new ArrayList<Node>();
        while (!this.eof() && (c = this.peek()) != ')' && c != '|') {
            sequence.add(this.parseTerm());
        }
        if (sequence.isEmpty()) {
            return EmptyNode.INSTANCE;
        }
        if (sequence.size() == 1) {
            return (Node)sequence.getFirst();
        }
        return new SequenceNode(sequence);
    }

    private Node parseTerm() throws PatternSyntaxException {
        Node base = this.parseAtom();
        if (this.eof()) {
            return base;
        }
        char c = this.peek();
        if (c == '*' || c == '+' || c == '?') {
            int min;
            this.consume();
            int max = switch (c) {
                case '*' -> {
                    min = 0;
                    yield -1;
                }
                case '+' -> {
                    min = 1;
                    yield -1;
                }
                default -> {
                    min = 0;
                    yield 1;
                }
            };
            boolean possessive = this.consumeIf('+');
            boolean lazy = !possessive && this.consumeIf('?');
            return new QuantifierNode(base, min, max, lazy, possessive);
        }
        if (c == '{') {
            this.consume();
            String first = this.readMatching(Character::isDigit);
            if (first.isEmpty()) {
                throw this.error("Expected number in quantifier");
            }
            int min = Integer.parseInt(first);
            if (min < 0) {
                throw this.error("Quantifier number out of range");
            }
            int max = min;
            boolean hasComma = this.consumeIf(',');
            if (hasComma) {
                String second = this.readMatching(Character::isDigit);
                if (second.isEmpty()) {
                    max = -1;
                } else {
                    max = Integer.parseInt(second);
                    if (max < 0) {
                        throw this.error("Quantifier number out of range");
                    }
                }
            }
            if (!this.consumeIf('}')) {
                throw this.error("Unterminated quantifier");
            }
            boolean possessive = this.consumeIf('+');
            boolean lazy = !possessive && this.consumeIf('?');
            return new QuantifierNode(base, min, max, lazy, possessive);
        }
        return base;
    }

    private Node parseAtom() throws PatternSyntaxException {
        if (this.eof()) {
            throw this.error("Unexpected end of pattern");
        }
        char c = this.peek();
        if (c == '.') {
            this.consume();
            return DotNode.INSTANCE;
        }
        if (c == '^' || c == '$') {
            this.consume();
            return AnchorNode.fromChar(c);
        }
        if (c == '\\') {
            return this.parseEscape();
        }
        if (c == '[') {
            return this.parseCharacterClass();
        }
        if (c == '(') {
            return this.parseGroup();
        }
        return this.parseLiteral();
    }

    private Node parseEscape() throws PatternSyntaxException {
        this.consume();
        if (this.eof()) {
            throw this.error("Trailing backslash");
        }
        char c = this.consume();
        if (Character.isDigit(c)) {
            return new ReferenceNode(c);
        }
        return new EscapeNode(switch (c) {
            case 'u' -> {
                String hex = this.readMatching(ch -> Character.isDigit(ch.charValue()) || ch.charValue() >= 'a' && ch.charValue() <= 'f' || ch.charValue() >= 'A' && ch.charValue() <= 'F', 4);
                if (hex.length() != 4) {
                    throw this.error("Invalid unicode escape");
                }
                yield "\\u" + hex;
            }
            default -> "\\" + c;
        });
    }

    private Node parseLiteral() throws PatternSyntaxException {
        String text = this.readMatching(ch -> "().|*+?[]{}^$\\".indexOf(ch.charValue()) == -1);
        if (text.isEmpty()) {
            return EmptyNode.INSTANCE;
        }
        return new LiteralNode(text);
    }

    private CharacterClassNode parseCharacterClass() throws PatternSyntaxException {
        this.consume();
        boolean negated = this.consumeIf('^');
        ArrayList<CharacterClassElement> elements = new ArrayList<CharacterClassElement>();
        while (!this.eof()) {
            if (this.peek() == ']') {
                this.consume();
                return new CharacterClassNode(negated, elements);
            }
            elements.add(this.parseCharacterClassElement());
        }
        throw this.error("Unterminated character class");
    }

    private CharacterClassElement parseCharacterClassElement() throws PatternSyntaxException {
        if (this.peek() == '\\') {
            this.consume();
            if (this.eof()) {
                throw this.error("Trailing backslash");
            }
            char c = this.consume();
            return new CharacterLiteralElement(String.valueOf(c));
        }
        if (this.peek() == '[') {
            return this.parseCharacterClass();
        }
        char c = this.consume();
        if (!this.eof() && this.peek() == '-' && this.peek(1) != ']') {
            char b;
            this.consume();
            if (this.eof()) {
                throw this.error("Unterminated character class");
            }
            if (this.peek() == '\\') {
                Node node = this.parseEscape();
                if (!(node instanceof EscapeNode)) {
                    throw this.error("Expected escape sequence");
                }
                EscapeNode esc = (EscapeNode)node;
                b = esc.asChar();
            } else {
                b = this.consume();
            }
            return new CharacterRangeElement(String.valueOf(c), String.valueOf(b));
        }
        return new CharacterLiteralElement(String.valueOf(c));
    }

    private Node parseGroup() throws PatternSyntaxException {
        this.consume();
        String name = null;
        GroupType type = GroupType.Capturing;
        if (this.consumeIf('?')) {
            char c = this.peek();
            if (c == ':') {
                this.consume();
                type = GroupType.NonCapturing;
            } else if (c == '=') {
                this.consume();
                type = GroupType.PositiveLookahead;
            } else if (c == '!') {
                this.consume();
                type = GroupType.NegativeLookahead;
            } else if (c == '<') {
                this.consume();
                c = this.peek();
                if (c == '=') {
                    this.consume();
                    type = GroupType.PositiveLookbehind;
                } else if (c == '!') {
                    this.consume();
                    type = GroupType.NegativeLookbehind;
                } else {
                    name = this.readMatching(ch -> Character.isLetterOrDigit(ch.charValue()) || ch.charValue() == '_');
                    if (!this.consumeIf('>')) {
                        throw this.error("Unterminated named capturing group");
                    }
                    type = GroupType.NamedCapturing;
                }
            } else {
                throw this.error("Unknown group construct");
            }
        }
        Node inner = this.parseAlternation();
        if (!this.consumeIf(')')) {
            throw this.error("Expected ')'");
        }
        return new GroupNode(inner, type, name);
    }

    public static sealed interface Node
    permits AlternationNode, AnchorNode, CharacterClassNode, DotNode, EscapeNode, EmptyNode, GroupNode, LiteralNode, QuantifierNode, ReferenceNode, SequenceNode {
        @Nullable
        default public List<Node> getChildren() {
            return null;
        }

        default public int repetitions() {
            List<Node> children = this.getChildren();
            if (children != null) {
                return children.stream().mapToInt(Node::repetitions).sum();
            }
            return 1;
        }

        default public int starHeight() {
            List<Node> children = this.getChildren();
            if (children != null) {
                return children.stream().mapToInt(Node::starHeight).max().orElse(0);
            }
            return 0;
        }
    }

    public record AlternationNode(List<Node> branches) implements Node
    {
        @Override
        @Nullable
        public List<Node> getChildren() {
            return this.branches;
        }

        @Override
        public int repetitions() {
            List<Node> children = this.getChildren();
            if (children != null) {
                return children.stream().mapToInt(Node::repetitions).max().orElse(1);
            }
            return 1;
        }

        @Override
        public String toString() {
            return this.branches.stream().map(Object::toString).collect(Collectors.joining("|"));
        }
    }

    public static final class EmptyNode
    implements Node {
        public static final EmptyNode INSTANCE = new EmptyNode();

        public String toString() {
            return "";
        }
    }

    public record SequenceNode(List<Node> children) implements Node
    {
        @Override
        public List<Node> getChildren() {
            return this.children;
        }

        @Override
        public String toString() {
            return this.children.stream().map(Object::toString).collect(Collectors.joining(""));
        }
    }

    public record QuantifierNode(Node child, int min, int max, boolean lazy, boolean possessive) implements Node
    {
        public static final int INFINITE = -1;

        public boolean isInfinite() {
            return this.max == -1;
        }

        @Override
        public int repetitions() {
            if (this.isInfinite()) {
                return -1;
            }
            return this.child.repetitions() * this.max;
        }

        @Override
        public int starHeight() {
            return this.child.starHeight() + (this.isInfinite() ? 1 : 0);
        }

        @Override
        public List<Node> getChildren() {
            return List.of(this.child);
        }

        @Override
        public String toString() {
            String q;
            if (this.min == 0 && this.max == 1) {
                q = "?";
            } else if (this.min == 0 && this.max == -1) {
                q = "*";
            } else if (this.min == 1 && this.max == -1) {
                q = "+";
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                sb.append(this.min);
                if (this.max != this.min) {
                    sb.append(",");
                    if (!this.isInfinite()) {
                        sb.append(this.max);
                    }
                }
                sb.append('}');
                q = sb.toString();
            }
            return String.valueOf(this.child) + q + (this.lazy ? "?" : (this.possessive ? "+" : ""));
        }
    }

    public static final class DotNode
    implements Node {
        public static final DotNode INSTANCE = new DotNode();

        public String toString() {
            return ".";
        }
    }

    public record AnchorNode(AnchorType type) implements Node
    {
        public static AnchorNode fromChar(char input) throws PatternSyntaxException {
            return switch (input) {
                case '^' -> new AnchorNode(AnchorType.Start);
                case '$' -> new AnchorNode(AnchorType.End);
                default -> throw new PatternSyntaxException("Invalid anchor character", String.valueOf(input), 0);
            };
        }

        @Override
        public String toString() {
            return this.type == AnchorType.Start ? "^" : "$";
        }
    }

    public record CharacterClassNode(boolean negated, List<CharacterClassElement> elements) implements CharacterClassElement,
    Node
    {
        @Override
        public String toString() {
            return "[" + (this.negated ? "^" : "") + this.elements.stream().map(Object::toString).collect(Collectors.joining()) + "]";
        }
    }

    public record ReferenceNode(char which) implements Node
    {
        @Override
        public String toString() {
            return "\\" + this.which;
        }
    }

    public record EscapeNode(String text) implements Node
    {
        @Override
        public String toString() {
            return this.text;
        }

        public char asChar() {
            if (this.text.length() == 2 && this.text.charAt(0) == '\\') {
                char c = this.text.charAt(1);
                return switch (c) {
                    case 'n' -> '\n';
                    case 'r' -> '\r';
                    case 't' -> '\t';
                    case 'f' -> '\f';
                    default -> c;
                };
            }
            if (this.text.startsWith("\\u")) {
                String h = this.text.substring(2);
                int v = Integer.parseInt(h, 16);
                return (char)v;
            }
            throw new PatternSyntaxException("Unsupported escape character", this.text, 1);
        }
    }

    public record LiteralNode(String literal) implements Node
    {
        @Override
        public String toString() {
            return this.literal;
        }
    }

    public static sealed interface CharacterClassElement
    permits CharacterClassNode, CharacterLiteralElement, CharacterRangeElement {
    }

    public record CharacterLiteralElement(String literal) implements CharacterClassElement
    {
        @Override
        public String toString() {
            return this.literal;
        }
    }

    public record CharacterRangeElement(String start, String end) implements CharacterClassElement
    {
        @Override
        public String toString() {
            return this.start + "-" + this.end;
        }
    }

    public static enum GroupType {
        Capturing,
        NonCapturing,
        NamedCapturing,
        PositiveLookahead,
        NegativeLookahead,
        PositiveLookbehind,
        NegativeLookbehind;

    }

    public record GroupNode(Node child, GroupType type, String name) implements Node
    {
        @Override
        public List<Node> getChildren() {
            return List.of(this.child);
        }

        @Override
        public String toString() {
            String extended = "";
            return "(" + extended + String.valueOf(this.child) + ")";
        }
    }

    public static enum AnchorType {
        Start,
        End;

    }
}

