/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.integration.farmersdelight.burner;

import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import plus.dragons.createcentralkitchen.client.burner.BlazeBurnerRenderOverride;
import plus.dragons.createcentralkitchen.client.registry.CCKPartialModels;
import plus.dragons.createcentralkitchen.integration.ModIntegration;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.tag.ModTags;

public enum BlazeChefRenderOverride implements BlazeBurnerRenderOverride
{
    FIERY_COOKING_POT(ModIntegration.TWILIGHTDELIGHT.asResource("fiery_cooking_pot"), CCKPartialModels.FIERY_CHEF_HAT, CCKPartialModels.FIERY_CHEF_HAT_SMALL),
    POTTERY_COOKING_OIT(ModIntegration.TRAILANDTALESDELIGHT.asResource("pottery_cooking_pot"), CCKPartialModels.POTTERY_CHEF_HAT, CCKPartialModels.POTTERY_CHEF_HAT_SMALL),
    DEFAULT(null, CCKPartialModels.CHEF_HAT, CCKPartialModels.CHEF_HAT_SMALL);

    @Nullable
    final ResourceLocation specialHatRenderHeatable;
    final PartialModel hat;
    final PartialModel smallHat;

    private BlazeChefRenderOverride(ResourceLocation specialHatRenderHeatable, PartialModel hat, PartialModel smallHat) {
        this.specialHatRenderHeatable = specialHatRenderHeatable;
        this.hat = hat;
        this.smallHat = smallHat;
    }

    @Override
    public boolean isValid(Level level, BlockPos pos, BlazeBurnerBlockEntity burner) {
        if (this.specialHatRenderHeatable == null) {
            HeatableBlockEntity heatable;
            BlockEntity blockEntity;
            if (level.getBlockEntity(pos.above()) instanceof HeatableBlockEntity) {
                return true;
            }
            return level.getBlockState(pos.above()).is(ModTags.HEAT_CONDUCTORS) && (blockEntity = level.getBlockEntity(pos.above(2))) instanceof HeatableBlockEntity && !(heatable = (HeatableBlockEntity)blockEntity).requiresDirectHeat();
        }
        return BuiltInRegistries.BLOCK.getKey((Object)level.getBlockState(pos.above()).getBlock()).equals((Object)this.specialHatRenderHeatable);
    }

    @Override
    public boolean isValidBlockAbove(boolean original) {
        return true;
    }

    @Override
    public PartialModel getHatModel(boolean small) {
        return small ? this.smallHat : this.hat;
    }
}

