/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim;

import com.tom.cpl.function.FloatUnaryOperator;
import com.tom.cpm.shared.animation.InterpolationInfo;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.anim.AnimLoaderState;
import com.tom.cpm.shared.parts.anim.AnimationFrameData;
import com.tom.cpm.shared.parts.anim.AnimationFrameDataType;
import com.tom.cpm.shared.parts.anim.AnimatorChannel;
import com.tom.cpm.shared.parts.anim.SerializedAnimation;
import com.tom.cpm.shared.parts.anim.TagType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConstantTimeBool
implements AnimationFrameData {
    private boolean[] frames;

    public ConstantTimeBool(boolean[] frames) {
        this.frames = frames;
    }

    public static void parse(IOHelper block, AnimLoaderState state) throws IOException {
        SerializedAnimation cA = state.getAnim();
        int frames = block.readVarInt();
        int compCount = block.readVarInt();
        for (int i = 0; i < compCount; ++i) {
            int channelID = block.readVarInt();
            AnimatorChannel ch = cA.animatorChannels.get(channelID);
            boolean[] f = block.readBoolArray(frames);
            ch.frameData = new ConstantTimeBool(f);
        }
    }

    public static void write(List<SerializedAnimation.AnimFrame<ConstantTimeBool>> frames, IOHelper h) throws IOException {
        HashMap groups = new HashMap();
        frames.forEach(f -> groups.computeIfAbsent(((ConstantTimeBool)f.data).frames.length, __ -> new ArrayList()).add(f));
        for (Map.Entry e : groups.entrySet()) {
            IOHelper d = h.writeNextObjectBlock(TagType.CONSTANT_FRAME_TIME_BOOLEAN);
            try {
                int fs = (Integer)e.getKey();
                d.writeVarInt(fs);
                d.writeVarInt(((List)e.getValue()).size());
                for (SerializedAnimation.AnimFrame f2 : (List)e.getValue()) {
                    d.writeVarInt(f2.channel);
                    d.writeBoolArray(fs, ((ConstantTimeBool)f2.data).frames);
                }
            }
            finally {
                if (d == null) continue;
                d.close();
            }
        }
    }

    @Override
    public AnimationFrameDataType getType() {
        return AnimationFrameDataType.CONSTANT_FRAME_BOOL;
    }

    @Override
    public FloatUnaryOperator createDriver(InterpolationInfo part) {
        return new ConstantTimeBoolDriver(this.frames);
    }

    public static class ConstantTimeBoolDriver
    implements FloatUnaryOperator {
        private final boolean[] frames;

        public ConstantTimeBoolDriver(boolean[] frames) {
            this.frames = frames;
        }

        @Override
        public float apply(float value) {
            return this.frames[(int)(value * (float)this.frames.length)] ? 1.0f : 0.0f;
        }
    }
}

