/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.gesture;

import com.tom.cpl.gui.elements.DropDownBox;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.math.Box;
import com.tom.cpl.util.NamedElement;
import com.tom.cpm.shared.gui.gesture.IGestureButton;
import com.tom.cpm.shared.gui.gesture.IGestureButtonContainer;
import com.tom.cpm.shared.parts.anim.menu.AbstractDropdownButtonData;

public class GestureDropdown
extends Panel
implements IGestureButton {
    private NamedElement.NameMapper<String> gestureNameMapper;
    private DropDownBox<NamedElement<String>> box;

    public GestureDropdown(IGestureButtonContainer c, AbstractDropdownButtonData data) {
        super(c.gui());
        String none = this.gui.i18nFormat("label.cpm.layerNone", new Object[0]);
        this.gestureNameMapper = new NamedElement.NameMapper<String>(data.getActiveOptions(), e -> e.isEmpty() ? none : e);
        this.box = new DropDownBox<NamedElement<String>>(this.gui.getFrame(), this.gestureNameMapper.asList());
        this.gestureNameMapper.setSetter(this.box::setSelected);
        this.addElement(new Label(this.gui, data.getName()).setBounds(new Box(0, 0, 70, 10)));
        this.addElement(this.box);
        this.box.setAction(() -> {
            data.set(this.box.getSelected().getElem());
            c.valueChanged();
        });
        this.gestureNameMapper.setValue(data.get());
    }

    @Override
    public GuiElement setBounds(Box bounds) {
        if (bounds.h < 30) {
            this.box.setBounds(new Box(bounds.w / 2, 0, bounds.w / 2, bounds.h));
        } else {
            this.box.setBounds(new Box(0, 10, bounds.w, bounds.h - 10));
        }
        return super.setBounds(bounds);
    }

    @Override
    public void updateKeybinds() {
    }
}

