/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.template.args;

import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.gui.ModeDisplayType;
import com.tom.cpm.shared.editor.template.TemplateArgHandler;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.model.Cube;
import com.tom.cpm.shared.template.args.ArgBase;
import com.tom.cpm.shared.template.args.ColorArg;
import java.util.List;
import java.util.Map;

public class ColorEditorArg
implements TemplateArgHandler.TemplateArg<ColorArg> {
    private int value;
    private String name = "color_" + Long.toString(System.nanoTime() % 65535L, 36);
    private ColorArg backingArg;

    @Override
    public void saveProject(Map<String, Object> m) {
        m.put("color", Integer.toHexString(this.value));
        m.put("name", this.name);
    }

    @Override
    public void loadProject(Map<String, Object> m) {
        this.value = Integer.parseUnsignedInt((String)m.get("color"), 16);
        this.name = (String)m.get("name");
    }

    @Override
    public ColorArg export() {
        return new ColorArg(this.name, this.value);
    }

    @Override
    public void applyArgs(Map<String, Object> data, List<ModelElement> parts) {
        List cubesList = (List)data.get("cubes");
        for (int i = 0; i < cubesList.size(); ++i) {
            Map map = (Map)cubesList.get(i);
            int id = ((Number)map.get("id")).intValue();
            parts.forEach(e -> {
                if (e.id == id) {
                    map.put("color", ArgBase.wrapName(this.name));
                }
            });
        }
    }

    @Override
    public void apply(List<? extends Cube> parts) {
        parts.forEach(p -> {
            p.rgb = this.value;
        });
    }

    @Override
    public void createTreeElements(List<TreeElement> c, final Editor editor) {
        c.add(new TreeElement(){

            @Override
            public String getName() {
                return editor.ui.i18nFormat("label.cpm.defaultColor", new Object[0]);
            }

            @Override
            public void setElemColor(int color) {
                ColorEditorArg.this.value = color;
                editor.updateGui();
            }

            @Override
            public void updateGui() {
                editor.setModePanel.accept(ModeDisplayType.COLOR);
                editor.setPartColor.accept(ColorEditorArg.this.value);
            }
        });
    }

    @Override
    public void loadTemplate(ColorArg a) {
        this.value = a.getColor();
        this.name = a.getName();
        this.backingArg = a;
    }

    @Override
    public void applyToArg() {
        this.backingArg.setColor(this.value);
    }
}

