/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.definition.Link;
import java.util.function.Consumer;

public class CreateGistPopup
extends PopupPanel {
    public CreateGistPopup(Frame frm, IGui gui, String reason, String text, Consumer<Link> ok) {
        super(gui);
        this.setBounds(new Box(0, 0, 260, 120));
        Label lbl1 = new Label(gui, gui.i18nFormat("label.cpm." + reason, new Object[0]));
        lbl1.setBounds(new Box(5, 0, 0, 0));
        this.addElement(lbl1);
        Label lbl2 = new Label(gui, gui.i18nFormat("label.cpm.createGist", new Object[0]));
        lbl2.setBounds(new Box(5, 10, 0, 0));
        this.addElement(lbl2);
        TextField txtf = new TextField(gui);
        txtf.setText(text);
        txtf.setBounds(new Box(5, 20, 205, 20));
        this.addElement(txtf);
        Label lbl3 = new Label(gui, gui.i18nFormat("label.cpm.uploadURL", new Object[0]));
        lbl3.setBounds(new Box(5, 45, 0, 0));
        this.addElement(lbl3);
        Label lbl4 = new Label(gui, "");
        TextField urlf = new TextField(gui);
        urlf.setBounds(new Box(5, 55, 205, 20));
        urlf.setEventListener(() -> this.checkURL(frm, urlf.getText(), lbl4, null));
        this.addElement(urlf);
        lbl4.setBounds(new Box(5, 80, 250, 10));
        this.addElement(lbl4);
        Button okBtn = new Button(gui, gui.i18nFormat("button.cpm.ok", new Object[0]), () -> this.checkURL(frm, urlf.getText(), lbl4, l -> {
            ok.accept((Link)l);
            this.close();
        }));
        okBtn.setBounds(new Box(110, 90, 40, 20));
        this.addElement(okBtn);
        Button cpyBtn = new Button(gui, gui.i18nFormat("button.cpm.copy", new Object[0]), () -> gui.setClipboardText(text));
        cpyBtn.setBounds(new Box(215, 20, 40, 20));
        this.addElement(cpyBtn);
        Button pasteBtn = new Button(gui, gui.i18nFormat("button.cpm.paste", new Object[0]), () -> {
            urlf.setText(gui.getClipboardText());
            this.checkURL(frm, urlf.getText(), lbl4, null);
        });
        pasteBtn.setBounds(new Box(215, 55, 40, 20));
        this.addElement(pasteBtn);
    }

    private void checkURL(Frame frm, String text, Label setter, Consumer<Link> linkConsumer) {
        if (text.isEmpty()) {
            setter.setText("");
            setter.setTooltip(null);
            return;
        }
        if (text.startsWith("https://gist.github.com/")) {
            String[] sp = (text = text.substring("https://gist.github.com/".length())).split("/");
            if (sp.length < 2) {
                setter.setText("Inavlid Gist URL");
                setter.setTooltip(new Tooltip(frm, "Your link should look like this:\\https://gist.github.com/<name>/<gist>"));
                return;
            }
            setter.setText("");
            setter.setTooltip(null);
            if (linkConsumer != null) {
                linkConsumer.accept(new Link("git", sp[0] + "/" + sp[1]));
            }
            return;
        }
        setter.setText("Unknown URL");
        setter.setTooltip(new Tooltip(frm, "Unknown link, currently only GitHub Gists are supported."));
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("label.cpm.exportSkin", new Object[0]);
    }
}

