/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.stacktrace;

import fudge.notenoughcrashes.NotEnoughCrashes;
import fudge.notenoughcrashes.platform.NecPlatform;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.CrashReport;
import net.minecraft.ReportType;
import net.minecraft.client.Minecraft;

public final class CrashUtils {
    public static void outputClientReport(CrashReport report) {
        CrashUtils.outputReport(report, true);
    }

    public static void outputReport(CrashReport report, boolean isClient) {
        try {
            if (report.getSaveFile() == null) {
                Object reportName = "crash-";
                reportName = (String)reportName + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
                reportName = (String)reportName + (isClient && Minecraft.getInstance().isSameThread() ? "-client" : "-server");
                reportName = (String)reportName + ".txt";
                Path reportsDir = NecPlatform.instance().getGameDirectory().resolve("crash-reports");
                Path reportFile = reportsDir.resolve((String)reportName);
                report.saveToFile(reportFile, ReportType.CRASH);
            }
        }
        catch (Throwable e) {
            NotEnoughCrashes.getLogger().fatal("Failed saving report", e);
        }
        NotEnoughCrashes.getLogger().fatal("Minecraft ran into a problem! " + (String)(report.getSaveFile() != null ? "Report saved to: " + String.valueOf(report.getSaveFile()) : "Crash report could not be saved.") + "\n" + report.getFriendlyReport(ReportType.CRASH));
    }
}

