/*
 * Decompiled with CFR 0.152.
 */
package com.divnectar.createblockchain.item;

import com.divnectar.createblockchain.block.ModBlocks;
import com.divnectar.createblockchain.item.ModItems;
import com.mojang.serialization.Codec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.energy.ComponentEnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RemoteFinderItem
extends Item {
    private static final String MODID = "createblockchain";
    private static final int ENERGY_CAPACITY = 10000;
    private static final int MAX_RECEIVE = 500;
    private static final int MAX_EXTRACT = 500;
    private static final int ENERGY_PER_SCAN = 150;
    private static final int SEARCH_RADIUS = 128;
    private static final float MIN_PITCH = 0.5f;
    private static final float MAX_PITCH = 2.0f;
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENTS = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"createblockchain");
    public static DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> ENERGY_COMPONENT;

    public RemoteFinderItem(Item.Properties props) {
        super(props.stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
        }
        if (energy.extractEnergy(150, true) < 150) {
            if (!level.isClientSide) {
                player.displayClientMessage((Component)Component.literal((String)"Remote Finder is out of power!").withStyle(ChatFormatting.RED), true);
            }
            RemoteFinderItem.playBeep(level, player, 0.5f);
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
        }
        energy.extractEnergy(150, false);
        if (!level.isClientSide) {
            BlockPos start = player.blockPosition();
            BlockPos nearest = RemoteFinderItem.findNearestSpiralingOutwards(level, start, 128);
            if (nearest != null) {
                double dist = Math.sqrt(start.distSqr((Vec3i)nearest));
                float norm = (float)Mth.clamp((double)(dist / 128.0), (double)0.0, (double)1.0);
                float pitch = Mth.clamp((float)(2.0f - 1.5f * norm), (float)0.5f, (float)2.0f);
                RemoteFinderItem.playBeep(level, player, pitch);
                player.displayClientMessage((Component)Component.literal((String)("Mining core detected: " + (int)dist + " blocks")).withStyle(ChatFormatting.GREEN), true);
            } else {
                RemoteFinderItem.playBeep(level, player, 0.7f);
                player.displayClientMessage((Component)Component.literal((String)"No mining core in range.").withStyle(ChatFormatting.GRAY), true);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            return 0;
        }
        return Math.round(13.0f * (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored());
    }

    public int getBarColor(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            return super.getBarColor(stack);
        }
        float fraction = (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored();
        return Mth.hsvToRgb((float)(Math.max(0.0f, fraction) / 3.0f), (float)1.0f, (float)1.0f);
    }

    @Nullable
    private static BlockPos findNearestSpiralingOutwards(Level level, BlockPos origin, int radius) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int minY = level.getMinBuildHeight();
        int maxY = origin.getY();
        if (level.getBlockState(origin).is((Block)ModBlocks.MINING_CORE_GEODE.get())) {
            return origin;
        }
        for (int r = 1; r <= radius; ++r) {
            for (int y = maxY; y >= minY; --y) {
                for (int x = -r; x <= r; ++x) {
                    for (int z = -r; z <= r; ++z) {
                        if (Math.abs(x) != r && Math.abs(z) != r) continue;
                        mutablePos.set(origin.getX() + x, y, origin.getZ() + z);
                        if (!level.getBlockState((BlockPos)mutablePos).is((Block)ModBlocks.MINING_CORE_GEODE.get())) continue;
                        return mutablePos.immutable();
                    }
                }
            }
        }
        return null;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy != null) {
            tooltip.add((Component)Component.literal((String)("Energy: " + energy.getEnergyStored() + " / " + energy.getMaxEnergyStored() + " FE")).withStyle(ChatFormatting.GRAY));
        }
    }

    private static void playBeep(Level level, Player player, float pitch) {
        level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_PLING.value(), SoundSource.PLAYERS, 1.0f, pitch);
    }

    public static void registerDataComponents(IEventBus modBus) {
        ENERGY_COMPONENT = DATA_COMPONENTS.register("remote_finder_energy", () -> DataComponentType.builder().persistent((Codec)Codec.INT).build());
        DATA_COMPONENTS.register(modBus);
    }

    public static class CapabilityHooks {
        @SubscribeEvent
        public static void registerCaps(RegisterCapabilitiesEvent event) {
            event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, ctx) -> new ComponentEnergyStorage((MutableDataComponentHolder)stack, (DataComponentType)ENERGY_COMPONENT.value(), 10000, 500, 500), new ItemLike[]{(ItemLike)ModItems.REMOTE_FINDER.get()});
        }
    }
}

