/*
 * Decompiled with CFR 0.152.
 */
package dev.kleinbox.cccbridge.common.minecraft.blockEntity;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import dan200.computercraft.api.peripheral.IPeripheral;
import dev.kleinbox.cccbridge.common.CCCRegistries;
import dev.kleinbox.cccbridge.common.computercraft.peripherals.ScrollerBlockPeripheral;
import dev.kleinbox.cccbridge.common.create.behaviour.LuaScrollValueBehaviour;
import dev.kleinbox.cccbridge.common.minecraft.blockEntity.PeripheralBlockEntity;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ScrollerBlockEntity
extends SmartBlockEntity
implements PeripheralBlockEntity {
    private ScrollerBlockPeripheral peripheral;
    private boolean locked = false;
    private boolean quietly = false;
    private boolean updateLock = false;
    private LuaScrollValueBehaviour scroller;

    public ScrollerBlockEntity(BlockPos pos, BlockState state) {
        super(CCCRegistries.SCROLLER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public IPeripheral getPeripheral(@Nullable Direction side) {
        if (side == ((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING)).getOpposite() || side == null) {
            if (this.peripheral == null) {
                this.peripheral = new ScrollerBlockPeripheral(this);
            }
            return this.peripheral;
        }
        return null;
    }

    public void setLock(boolean state) {
        this.locked = state;
        this.updateLock = true;
    }

    public int getValue() {
        return this.scroller.getValue();
    }

    public void setValueQuietly(int value) {
        this.scroller.setValueQuietly(value);
    }

    public void nextChangeQuietly() {
        this.quietly = true;
    }

    public void fireUpdateValueEvent() {
        if (this.peripheral != null) {
            this.peripheral.sendEvent("scroller_changed", this.scroller.getValue());
        }
    }

    public static void tick(Level world, BlockPos blockPos, BlockState state, BlockEntity be) {
        if (!(be instanceof ScrollerBlockEntity)) {
            return;
        }
        ScrollerBlockEntity scroller = (ScrollerBlockEntity)be;
        if (scroller.updateLock && (Boolean)state.getValue((Property)BlockStateProperties.LOCKED) != scroller.locked) {
            world.playSound(null, blockPos, scroller.locked ? CCCRegistries.CAGE_LOCK_SOUND.get() : CCCRegistries.CAGE_UNLOCK_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.5f);
            world.setBlock(blockPos, (BlockState)state.setValue((Property)BlockStateProperties.LOCKED, (Comparable)Boolean.valueOf(scroller.locked)), 19);
            scroller.updateLock = false;
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        if (this.scroller == null) {
            this.scroller = new LuaScrollValueBehaviour(this, (ValueBoxTransform)new ControllerValueBoxTransform());
        }
        behaviours.add((BlockEntityBehaviour)this.scroller);
    }

    public int getLimit() {
        return this.scroller.getMax();
    }

    public void setLimit(int limit) {
        this.scroller.between(limit);
    }

    public boolean hasMinus() {
        return this.scroller.hasMinus();
    }

    public void toggleMinusSpectrum(boolean state) {
        this.scroller.setHasMinus(state);
    }

    private static class ControllerValueBoxTransform
    extends ValueBoxTransform.Sided {
        private ControllerValueBoxTransform() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)0.01);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return state.getValue((Property)BlockStateProperties.FACING) == direction;
        }
    }
}

