/*
 * Decompiled with CFR 0.152.
 */
package dev.kleinbox.cccbridge.common.minecraft.block;

import com.mojang.serialization.MapCodec;
import dev.kleinbox.cccbridge.common.CCCRegistries;
import dev.kleinbox.cccbridge.common.minecraft.blockEntity.ScrollerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ScrollerBlock
extends DirectionalBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BlockBehaviour.Properties SCROLLER_BLOCK_PROPERTIES = BlockBehaviour.Properties.of().strength(1.0f).sound(SoundType.METAL);

    public ScrollerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return ScrollerBlock.simpleCodec(ScrollerBlock::new);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{BlockStateProperties.FACING, BlockStateProperties.WATERLOGGED, BlockStateProperties.LOCKED});
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ScrollerBlockEntity(pos, state);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> ScrollerBlock.newBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.125f);
            case Direction.NORTH -> ScrollerBlock.newBox(0.0f, 0.0f, 0.875f, 1.0f, 1.0f, 1.0f);
            case Direction.WEST -> ScrollerBlock.newBox(0.875f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            case Direction.EAST -> ScrollerBlock.newBox(0.0f, 0.0f, 0.0f, 0.125f, 1.0f, 1.0f);
            case Direction.UP -> ScrollerBlock.newBox(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
            case Direction.DOWN -> ScrollerBlock.newBox(0.0f, 0.875f, 0.0f, 1.0f, 1.0f, 1.0f);
            default -> ScrollerBlock.newBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        };
    }

    private static VoxelShape newBox(float p1, float p2, float p3, float p4, float p5, float p6) {
        return Block.box((double)(p1 * 16.0f), (double)(p2 * 16.0f), (double)(p3 * 16.0f), (double)(p4 * 16.0f), (double)(p5 * 16.0f), (double)(p6 * 16.0f));
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level world, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return CCCRegistries.SCROLLER_BLOCK_ENTITY.get() == type ? ScrollerBlockEntity::tick : null;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)ctx.getClickedFace())).setValue((Property)BlockStateProperties.LOCKED, (Comparable)Boolean.valueOf(false));
    }
}

