/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.kineticbattery;

import com.hlysine.create_connected.CCBlockEntityTypes;
import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.CCItems;
import com.hlysine.create_connected.content.kineticbattery.KineticBatteryBlockEntity;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public class KineticBatteryBlock
extends DirectionalKineticBlock
implements IBE<KineticBatteryBlockEntity> {
    public static final IntegerProperty LEVEL = IntegerProperty.create((String)"level", (int)0, (int)5);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public KineticBatteryBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED, LEVEL});
        super.createBlockStateDefinition(builder);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            return super.getStateForPlacement(context);
        }
        Direction preferredDirection = this.getPreferredFacing(context);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)(preferredDirection == null ? context.getNearestLookingDirection() : preferredDirection))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())))).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        boolean doNotConsume = player.isCreative();
        boolean forceInsert = !(player instanceof FakePlayer);
        InteractionResultHolder<ItemStack> res = KineticBatteryBlock.tryInsert(state, level, pos, stack, doNotConsume, forceInsert, false);
        ItemStack leftover = (ItemStack)res.getObject();
        if (!(level.isClientSide || doNotConsume || leftover.isEmpty())) {
            if (stack.isEmpty()) {
                player.setItemInHand(hand, leftover);
            } else if (!player.getInventory().add(leftover)) {
                player.drop(leftover, false);
            }
        }
        return res.getResult() == InteractionResult.SUCCESS ? ItemInteractionResult.SUCCESS : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static InteractionResultHolder<ItemStack> tryInsert(BlockState state, Level world, BlockPos pos, ItemStack stack, boolean doNotConsume, boolean forceInsert, boolean simulate) {
        ItemStack returnedItem;
        if (stack.isEmpty()) {
            return InteractionResultHolder.fail((Object)ItemStack.EMPTY);
        }
        if (!state.hasBlockEntity()) {
            return InteractionResultHolder.fail((Object)ItemStack.EMPTY);
        }
        BlockEntity be = world.getBlockEntity(pos);
        if (!(be instanceof KineticBatteryBlockEntity)) {
            return InteractionResultHolder.fail((Object)ItemStack.EMPTY);
        }
        KineticBatteryBlockEntity batteryBE = (KineticBatteryBlockEntity)be;
        if (KineticBatteryBlock.isDischarging(state)) {
            if (!stack.is(CCItems.CHARGED_KINETIC_BATTERY)) {
                return InteractionResultHolder.fail((Object)ItemStack.EMPTY);
            }
            if (forceInsert && (Integer)state.getValue((Property)LEVEL) == 5) {
                return InteractionResultHolder.fail((Object)ItemStack.EMPTY);
            }
            if (!forceInsert && batteryBE.getBatteryLevel() > 72000.0) {
                return InteractionResultHolder.fail((Object)ItemStack.EMPTY);
            }
            if (!simulate) {
                batteryBE.setBatteryLevel(KineticBatteryBlockEntity.getMaxBatteryLevel());
            }
            returnedItem = CCBlocks.KINETIC_BATTERY.asStack();
        } else {
            if (!stack.is(CCBlocks.KINETIC_BATTERY.asItem())) {
                return InteractionResultHolder.fail((Object)ItemStack.EMPTY);
            }
            if ((Integer)state.getValue((Property)LEVEL) < 5) {
                return InteractionResultHolder.fail((Object)ItemStack.EMPTY);
            }
            if (!simulate) {
                batteryBE.setBatteryLevel(0.0);
            }
            returnedItem = CCItems.CHARGED_KINETIC_BATTERY.asStack();
        }
        if (!doNotConsume) {
            if (!world.isClientSide) {
                stack.shrink(1);
            }
            return InteractionResultHolder.success((Object)returnedItem);
        }
        return InteractionResultHolder.success((Object)ItemStack.EMPTY);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getAxis();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.getAxis() == this.getRotationAxis(state);
    }

    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        if (oldState.getValue((Property)FACING) != newState.getValue((Property)FACING)) {
            return false;
        }
        if (KineticBatteryBlock.isDischarging(oldState) != KineticBatteryBlock.isDischarging(newState)) {
            return false;
        }
        return KineticBatteryBlock.isCurrentStageComplete(oldState) == KineticBatteryBlock.isCurrentStageComplete(newState);
    }

    public void neighborChanged(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        if (worldIn.isClientSide) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.getValue((Property)POWERED);
        if (previouslyPowered != worldIn.hasNeighborSignal(pos)) {
            KineticBlockEntity.switchToBlockState((Level)worldIn, (BlockPos)pos, (BlockState)((BlockState)state.cycle((Property)POWERED)));
        }
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos) {
        return this.getBlockEntityOptional((BlockGetter)world, pos).map(be -> be.getCrudeBatteryLevel(15)).orElse(0);
    }

    @NotNull
    public ItemStack getCloneItemStack(BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Player player) {
        if ((Integer)state.getValue((Property)LEVEL) == 5) {
            return CCItems.CHARGED_KINETIC_BATTERY.asStack();
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public static boolean isDischarging(BlockState state) {
        return (Boolean)state.getValue((Property)POWERED);
    }

    public static boolean isCurrentStageComplete(BlockState state) {
        if (KineticBatteryBlock.isDischarging(state)) {
            return (Integer)state.getValue((Property)LEVEL) == 0;
        }
        return (Integer)state.getValue((Property)LEVEL) == 5;
    }

    public Class<KineticBatteryBlockEntity> getBlockEntityClass() {
        return KineticBatteryBlockEntity.class;
    }

    public BlockEntityType<? extends KineticBatteryBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CCBlockEntityTypes.KINETIC_BATTERY.get();
    }
}

