/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.itemsilo;

import com.hlysine.create_connected.CCBlockEntityTypes;
import com.hlysine.create_connected.content.itemsilo.ItemSiloBlock;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.packager.InventoryIdentifier;
import com.simibubi.create.foundation.ICapabilityProvider;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryWrapper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

@EventBusSubscriber(modid="create_connected", bus=EventBusSubscriber.Bus.MOD)
public class ItemSiloBlockEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainer.Inventory {
    protected ICapabilityProvider<IItemHandler> itemCapability = null;
    protected InventoryIdentifier invId;
    protected ItemStackHandler inventory;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity;
    protected int radius;
    protected int length;
    protected Direction.Axis axis;

    public ItemSiloBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = new ItemStackHandler((Integer)AllConfigs.server().logistics.vaultCapacity.get()){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ItemSiloBlockEntity.this.updateComparators();
                ItemSiloBlockEntity.this.level.blockEntityChanged(ItemSiloBlockEntity.this.worldPosition);
            }
        };
        this.radius = 1;
        this.length = 1;
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CCBlockEntityTypes.ITEM_SILO.get(), (be, context) -> {
            be.initCapability();
            if (be.itemCapability == null) {
                return null;
            }
            return (IItemHandler)be.itemCapability.getCapability();
        });
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.level.isClientSide()) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    protected void updateComparators() {
        ItemSiloBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        this.level.blockEntityChanged(controllerBE.worldPosition);
        BlockPos pos = controllerBE.getBlockPos();
        for (int y = 0; y < controllerBE.length; ++y) {
            for (int z = 0; z < controllerBE.radius; ++z) {
                for (int x = 0; x < controllerBE.radius; ++x) {
                    this.level.updateNeighbourForOutputSignal(pos.offset(x, y, z), this.getBlockState().getBlock());
                }
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.getBlockPos();
        } else if (!this.lastKnownPos.equals((Object)this.worldPosition) && this.worldPosition != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.worldPosition.getX() == this.controller.getX() && this.worldPosition.getY() == this.controller.getY() && this.worldPosition.getZ() == this.controller.getZ();
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.worldPosition;
    }

    public ItemSiloBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
        if (blockEntity instanceof ItemSiloBlockEntity) {
            return (ItemSiloBlockEntity)blockEntity;
        }
        return null;
    }

    public void removeController(boolean keepContents) {
        if (this.level.isClientSide()) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.radius = 1;
        this.length = 1;
        BlockState state = this.getBlockState();
        if (ItemSiloBlock.isVault(state)) {
            state = (BlockState)state.setValue((Property)ItemSiloBlock.LARGE, (Comparable)Boolean.valueOf(false));
            this.getLevel().setBlock(this.worldPosition, state, 22);
        }
        this.itemCapability = null;
        this.invalidateCapabilities();
        this.setChanged();
        this.sendData();
    }

    public void setController(BlockPos controller) {
        if (this.level.isClientSide && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.itemCapability = null;
        this.invalidateCapabilities();
        this.setChanged();
        this.sendData();
    }

    public BlockPos getController() {
        return this.isController() ? this.worldPosition : this.controller;
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, registries, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.radius;
        int prevLength = this.length;
        this.updateConnectivity = compound.contains("Uninitialized");
        this.lastKnownPos = null;
        if (compound.contains("LastKnownPos")) {
            this.lastKnownPos = NBTHelper.readBlockPos((CompoundTag)compound, (String)"LastKnownPos");
        }
        this.controller = null;
        if (compound.contains("Controller")) {
            this.controller = NBTHelper.readBlockPos((CompoundTag)compound, (String)"Controller");
        }
        if (this.isController()) {
            this.radius = compound.getInt("Size");
            this.length = compound.getInt("Length");
        }
        if (!clientPacket) {
            this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
            return;
        }
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (this.hasLevel() && (changeOfController || prevSize != this.radius || prevLength != this.length)) {
            this.level.setBlocksDirty(this.getBlockPos(), Blocks.AIR.defaultBlockState(), this.getBlockState());
        }
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.putBoolean("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.put("LastKnownPos", NbtUtils.writeBlockPos((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.put("Controller", NbtUtils.writeBlockPos((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.putInt("Size", this.radius);
            compound.putInt("Length", this.length);
        }
        super.write(compound, registries, clientPacket);
        if (!clientPacket) {
            compound.putString("StorageType", "CombinedInv");
            compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        }
    }

    public ItemStackHandler getInventoryOfBlock() {
        return this.inventory;
    }

    public InventoryIdentifier getInvId() {
        this.initCapability();
        return this.invId;
    }

    public void applyInventoryToBlock(ItemStackHandler handler) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, i < handler.getSlots() ? handler.getStackInSlot(i) : ItemStack.EMPTY);
        }
    }

    private void initCapability() {
        if (this.itemCapability != null && this.itemCapability.getCapability() != null) {
            return;
        }
        if (!this.isController()) {
            ItemSiloBlockEntity controllerBE = this.getControllerBE();
            if (controllerBE == null) {
                return;
            }
            controllerBE.initCapability();
            this.itemCapability = ICapabilityProvider.of(() -> {
                if (controllerBE.isRemoved()) {
                    return null;
                }
                if (controllerBE.itemCapability == null) {
                    return null;
                }
                return (IItemHandler)controllerBE.itemCapability.getCapability();
            });
            this.invId = controllerBE.invId;
            return;
        }
        IItemHandlerModifiable[] invs = new IItemHandlerModifiable[this.length * this.radius * this.radius];
        for (int yOffset = 0; yOffset < this.length; ++yOffset) {
            for (int xOffset = 0; xOffset < this.radius; ++xOffset) {
                for (int zOffset = 0; zOffset < this.radius; ++zOffset) {
                    BlockPos vaultPos = this.worldPosition.offset(xOffset, yOffset, zOffset);
                    ItemSiloBlockEntity vaultAt = (ItemSiloBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)CCBlockEntityTypes.ITEM_SILO.get()), (BlockGetter)this.level, (BlockPos)vaultPos);
                    invs[yOffset * this.radius * this.radius + xOffset * this.radius + zOffset] = vaultAt != null ? vaultAt.inventory : new ItemStackHandler();
                }
            }
        }
        this.itemCapability = ICapabilityProvider.of((Object)new VersionedInventoryWrapper((IItemHandlerModifiable)new CombinedInvWrapper(invs)));
        BlockPos farCorner = this.worldPosition.offset(this.radius, this.length, this.radius);
        BoundingBox bounds = BoundingBox.fromCorners((Vec3i)this.worldPosition, (Vec3i)farCorner);
        this.invId = new InventoryIdentifier.Bounds(bounds);
    }

    public static int getMaxLength(int radius) {
        return radius * 3;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.getBlockState();
        if (ItemSiloBlock.isVault(state)) {
            this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)ItemSiloBlock.LARGE, (Comparable)Boolean.valueOf(this.radius > 2)), 6);
        }
        this.itemCapability = null;
        this.invalidateCapabilities();
        this.setChanged();
    }

    public Direction.Axis getMainConnectionAxis() {
        return this.getMainAxisOf((BlockEntity)this);
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return ItemSiloBlockEntity.getMaxLength(width);
        }
        return this.getMaxWidth();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.length;
    }

    public int getWidth() {
        return this.radius;
    }

    public void setHeight(int height) {
        this.length = height;
    }

    public void setWidth(int width) {
        this.radius = width;
    }

    public boolean hasInventory() {
        return true;
    }
}

