/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.recipe;

import com.simibubi.create.content.kinetics.deployer.ManualApplicationRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public class RecipeApplier {
    public static void applyRecipeOn(ItemEntity entity, Recipe<?> recipe) {
        List<ItemStack> stacks = RecipeApplier.applyRecipeOn(entity.level(), entity.getItem(), recipe);
        if (stacks == null) {
            return;
        }
        if (stacks.isEmpty()) {
            entity.discard();
            return;
        }
        entity.setItem(stacks.remove(0));
        for (ItemStack additional : stacks) {
            ItemEntity entityIn = new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), additional);
            entityIn.setDeltaMovement(entity.getDeltaMovement());
            entity.level().addFreshEntity((Entity)entityIn);
        }
    }

    public static List<ItemStack> applyRecipeOn(Level level, ItemStack stackIn, RecipeHolder<?> recipe) {
        return RecipeApplier.applyRecipeOn(level, stackIn, recipe.value());
    }

    public static List<ItemStack> applyRecipeOn(Level level, ItemStack stackIn, Recipe<?> recipe) {
        ArrayList<ItemStack> stacks;
        if (recipe instanceof ProcessingRecipe) {
            ProcessingRecipe pr = (ProcessingRecipe)recipe;
            stacks = new ArrayList();
            for (int i = 0; i < stackIn.getCount(); ++i) {
                List<ProcessingOutput> list;
                if (pr instanceof ManualApplicationRecipe) {
                    ManualApplicationRecipe mar = (ManualApplicationRecipe)pr;
                    list = mar.getRollableResults();
                } else {
                    list = pr.getRollableResults();
                }
                List<ProcessingOutput> outputs = list;
                for (ItemStack stack : pr.rollResults(outputs)) {
                    for (ItemStack previouslyRolled : stacks) {
                        if (stack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)previouslyRolled)) continue;
                        int amount = Math.min((Integer)previouslyRolled.getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)64) - previouslyRolled.getCount(), stack.getCount());
                        previouslyRolled.grow(amount);
                        stack.shrink(amount);
                    }
                    if (stack.isEmpty()) continue;
                    stacks.add(stack);
                }
            }
        } else {
            ItemStack out = recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).copy();
            stacks = ItemHelper.multipliedOutput(stackIn, out);
        }
        return stacks;
    }
}

