/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.signal;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.trains.signal.SignalBlockEntity;
import com.simibubi.create.content.trains.signal.SignalBoundary;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.TickableVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleTickableVisual;
import java.util.function.Consumer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SignalVisual
extends AbstractBlockEntityVisual<SignalBlockEntity>
implements SimpleTickableVisual {
    private final TransformedInstance signalLight;
    private final TransformedInstance signalOverlay;
    private boolean previousIsRedLight;
    private SignalBlockEntity.OverlayState previousOverlayState;

    public SignalVisual(VisualizationContext ctx, SignalBlockEntity blockEntity, float partialTick) {
        super(ctx, (BlockEntity)blockEntity, partialTick);
        this.signalLight = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SIGNAL_OFF)).createInstance();
        this.signalOverlay = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.TRACK_SIGNAL_OVERLAY)).createInstance();
    }

    public void tick(TickableVisual.Context context) {
        ITrackBlock trackBlock;
        BlockState trackState;
        Level level;
        BlockPos targetPosition;
        TrackTargetingBehaviour<SignalBoundary> target;
        SignalBlockEntity.OverlayState overlayState;
        block7: {
            block6: {
                float renderTime;
                SignalBlockEntity.SignalState signalState = ((SignalBlockEntity)this.blockEntity).getState();
                boolean isRedLight = signalState.isRedLight(renderTime = AnimationTickHolder.getRenderTime((LevelAccessor)((SignalBlockEntity)this.blockEntity).getLevel()));
                if (isRedLight != this.previousIsRedLight) {
                    PartialModel partial = isRedLight ? AllPartialModels.SIGNAL_ON : AllPartialModels.SIGNAL_OFF;
                    this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)partial)).stealInstance((Instance)this.signalLight);
                }
                this.signalLight.setIdentityTransform().translate((Vec3i)this.getVisualPosition());
                if (isRedLight) {
                    this.signalLight.light(240);
                }
                this.signalLight.setChanged();
                this.previousIsRedLight = isRedLight;
                overlayState = ((SignalBlockEntity)this.blockEntity).getOverlay();
                target = ((SignalBlockEntity)this.blockEntity).edgePoint;
                targetPosition = target.getGlobalPosition();
                level = ((SignalBlockEntity)this.blockEntity).getLevel();
                trackState = level.getBlockState(targetPosition);
                Block block = trackState.getBlock();
                if (!(block instanceof ITrackBlock)) break block6;
                trackBlock = (ITrackBlock)block;
                if (overlayState != SignalBlockEntity.OverlayState.SKIP) break block7;
            }
            this.signalOverlay.setZeroTransform().setChanged();
            return;
        }
        this.signalOverlay.setIdentityTransform().translate((Vec3i)targetPosition);
        TrackTargetingBehaviour.RenderedTrackOverlayType type = overlayState == SignalBlockEntity.OverlayState.DUAL ? TrackTargetingBehaviour.RenderedTrackOverlayType.DUAL_SIGNAL : TrackTargetingBehaviour.RenderedTrackOverlayType.SIGNAL;
        PartialModel partial = trackBlock.prepareTrackOverlay(this.signalOverlay, (BlockGetter)level, targetPosition, trackState, target.getTargetBezier(), target.getTargetDirection(), type);
        if (overlayState != this.previousOverlayState) {
            this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)partial)).stealInstance((Instance)this.signalOverlay);
        }
        this.signalOverlay.setChanged();
        this.previousOverlayState = overlayState;
    }

    public void updateLight(float partialTick) {
        this.relight(new FlatLit[]{this.signalLight, this.signalOverlay});
    }

    protected void _delete() {
        this.signalLight.delete();
        this.signalOverlay.delete();
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.signalLight);
    }
}

