/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.inventory;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import de.srendi.advancedperipherals.common.util.StatusConstants;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.world.level.Level;

public abstract class BasicCraftJob {
    private static final String EVENT = "_crafting";
    private static final int JOB_DONE_PURGE_TIME = 300000;
    public static final AtomicLong ID_SEQ = new AtomicLong();
    protected final long id = ID_SEQ.incrementAndGet();
    protected final IComputerAccess computer;
    protected final String eventName;
    protected final long amount;
    protected final Level world;
    protected boolean startedCrafting = false;
    protected boolean startedCalculation = false;
    protected boolean calculationNotSuccessful = false;
    protected boolean errorOccurred = false;
    protected boolean isJobDone = false;
    protected long jobDoneTime = 0L;
    protected boolean isJobCanceled = false;
    protected String debugMessage = null;

    public BasicCraftJob(IComputerAccess computer, String eventName, Level world, long amount) {
        this.computer = computer;
        this.eventName = eventName;
        this.world = world;
        this.amount = amount;
    }

    @LuaFunction
    public final long getId() {
        return this.id;
    }

    protected abstract boolean isJobDone();

    @LuaFunction
    public final boolean isDone() {
        return this.isJobDone();
    }

    protected abstract boolean isJobCanceled();

    @LuaFunction
    public final boolean isCanceled() {
        return this.isJobCanceled();
    }

    @LuaFunction
    public final boolean isCraftingStarted() {
        return this.startedCrafting;
    }

    @LuaFunction
    public final boolean isCalculationStarted() {
        return this.startedCalculation;
    }

    @LuaFunction
    public final boolean isCalculationNotSuccessful() {
        return this.calculationNotSuccessful;
    }

    @LuaFunction
    public final boolean hasErrorOccurred() {
        return this.errorOccurred;
    }

    @LuaFunction
    public final String getDebugMessage() {
        return this.debugMessage;
    }

    @LuaFunction
    public final Object getRequestedItem() {
        return this.getParsedRequestedItemImpl();
    }

    @LuaFunction
    public final long getElapsedTime() {
        return this.getElapsedTimeImpl();
    }

    @LuaFunction
    public final long getTotalItems() {
        return this.getTotalItemsImpl();
    }

    @LuaFunction
    public final long getItemProgress() {
        return this.getItemProgressImpl();
    }

    @LuaFunction
    public final Object getEmittedItems() {
        return this.getEmittedItemsImpl();
    }

    @LuaFunction
    public final Object getUsedItems() {
        return this.getUsedItemsImpl();
    }

    @LuaFunction
    public final Object getMissingItems() {
        return this.getMissingItemsImpl();
    }

    @LuaFunction
    public final boolean hasMultiplePaths() {
        return this.hasMultiplePathsImpl();
    }

    @LuaFunction
    public final Object getFinalOutput() {
        return this.getFinalOutputImpl();
    }

    @LuaFunction
    public final boolean cancel() {
        return this.cancelImpl();
    }

    protected abstract Object getParsedRequestedItemImpl();

    protected abstract long getElapsedTimeImpl();

    protected abstract long getTotalItemsImpl();

    protected abstract long getItemProgressImpl();

    protected abstract Object getEmittedItemsImpl();

    protected abstract Object getUsedItemsImpl();

    protected abstract Object getMissingItemsImpl();

    protected abstract boolean hasMultiplePathsImpl();

    protected abstract Object getFinalOutputImpl();

    protected abstract boolean cancelImpl();

    protected Level getWorld() {
        return this.world;
    }

    protected long getAmount() {
        return this.amount;
    }

    public boolean canBePurged() {
        return this.calculationNotSuccessful || (this.isJobDone || this.isJobCanceled) && this.jobDoneTime + 300000L < System.currentTimeMillis();
    }

    protected void fireNotConnected() {
        this.fireEvent(true, StatusConstants.NOT_CONNECTED);
    }

    protected void setStartedCrafting() {
        this.startedCrafting = true;
        this.fireEvent(false, StatusConstants.CRAFTING_STARTED);
    }

    protected void setJobCanceled() {
        this.isJobCanceled = true;
        this.jobDoneTime = System.currentTimeMillis();
    }

    protected void setJobDone() {
        this.isJobDone = true;
        this.jobDoneTime = System.currentTimeMillis();
    }

    protected void fireEvent(boolean error, StatusConstants message) {
        this.computer.queueEvent(this.eventName + EVENT, new Object[]{error, this.id, message.toString()});
        this.debugMessage = message.toString();
        this.errorOccurred = error;
    }

    protected void fireEvent(boolean error, String message) {
        this.computer.queueEvent(this.eventName + EVENT, new Object[]{error, this.id, message});
        this.debugMessage = message;
        this.errorOccurred = error;
    }

    public void tick() {
        this.startCalculation();
        this.maybeCraft();
    }

    protected abstract void maybeCraft();

    protected abstract void startCalculation();

    public abstract void jobStateChanged();
}

