/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.NBTUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.world.chunk.RegisterTicketControllersEvent;
import net.neoforged.neoforge.common.world.chunk.TicketController;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="advancedperipherals")
public class ChunkManager
extends SavedData {
    private static final String DATA_NAME = "advancedperipherals_ForcedChunks";
    private static final String FORCED_CHUNKS_TAG = "forcedChunks";
    private static long tickCounter = 0L;
    private final Map<UUID, LoadChunkRecord> forcedChunks = new HashMap<UUID, LoadChunkRecord>();
    private boolean initialized = false;
    private static final TicketController controller = new TicketController(AdvancedPeripherals.getRL("chunkcontroller"), null);

    @NotNull
    public static ChunkManager get(@NotNull ServerLevel level) {
        return (ChunkManager)level.getDataStorage().computeIfAbsent(new SavedData.Factory(ChunkManager::new, ChunkManager::load, null), DATA_NAME);
    }

    public static ChunkManager load(@NotNull CompoundTag data, HolderLookup.Provider provider) {
        ChunkManager manager = new ChunkManager();
        CompoundTag forcedData = data.getCompound(FORCED_CHUNKS_TAG);
        AdvancedPeripherals.debug("Loading chunk manager from NBT " + String.valueOf(data), Level.WARN);
        for (String key : forcedData.getAllKeys()) {
            manager.forcedChunks.put(UUID.fromString(key), LoadChunkRecord.deserialize(forcedData.getCompound(key)));
        }
        return manager;
    }

    public static void registerTicketController(RegisterTicketControllersEvent event) {
        event.register(controller);
    }

    @SubscribeEvent
    public static void afterServerStarted(ServerStartedEvent event) {
        ChunkManager.get(event.getServer().overworld()).init();
    }

    @SubscribeEvent
    public static void serverTick(ServerTickEvent.Post event) {
        if (event.hasTime() && ++tickCounter % (long)((Integer)APConfig.PERIPHERALS_CONFIG.chunkLoadValidTime.get() * 20 / 10) == 0L) {
            ChunkManager.get(ServerLifecycleHooks.getCurrentServer().overworld()).cleanup();
        }
    }

    private static boolean forceChunk(UUID owner, ServerLevel level, ChunkPos pos) {
        AdvancedPeripherals.debug("Forcing chunk " + String.valueOf(pos), Level.WARN);
        return controller.forceChunk(level, owner, pos.x, pos.z, true, true);
    }

    private static boolean unforceChunk(UUID owner, ServerLevel level, ChunkPos pos) {
        AdvancedPeripherals.debug("Unforcing chunk " + String.valueOf(pos), Level.WARN);
        return controller.forceChunk(level, owner, pos.x, pos.z, false, true);
    }

    public synchronized boolean addForceChunk(ServerLevel level, UUID owner, ChunkPos pos) {
        AdvancedPeripherals.debug("Trying to load forced chunk cluster " + String.valueOf(pos), Level.WARN);
        LoadChunkRecord oldRecord = this.forcedChunks.get(owner);
        if (oldRecord != null) {
            ServerLevel oldLevel = ChunkManager.getServerLevel(oldRecord.getDimensionName());
            if (oldLevel == level && pos.equals((Object)oldRecord.getPos())) {
                return true;
            }
            this.unforceChunkRecord(owner, oldRecord, oldLevel);
        }
        int chunkRadius = (Integer)APConfig.PERIPHERALS_CONFIG.chunkyTurtleRadius.get();
        this.forcedChunks.put(owner, new LoadChunkRecord(level.dimension().location().toString(), pos, chunkRadius));
        this.setDirty();
        boolean result = true;
        for (int x = -chunkRadius; x <= chunkRadius; ++x) {
            for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                result &= ChunkManager.forceChunk(owner, level, new ChunkPos(pos.x + x, pos.z + z));
            }
        }
        return result;
    }

    public synchronized void touch(UUID owner) {
        LoadChunkRecord forcedChunk = this.forcedChunks.get(owner);
        if (forcedChunk != null) {
            forcedChunk.touch();
        }
    }

    public synchronized boolean removeForceChunk(ServerLevel level, UUID owner) {
        AdvancedPeripherals.debug("Attempting to unload forced chunk cluster " + String.valueOf(owner), Level.WARN);
        LoadChunkRecord chunkRecord = this.forcedChunks.get(owner);
        if (chunkRecord == null) {
            return true;
        }
        String dimensionName = level.dimension().location().toString();
        if (!chunkRecord.getDimensionName().equals(dimensionName)) {
            throw new IllegalArgumentException(String.format("Incorrect dimension! Should be %s instead of %s", chunkRecord.getDimensionName(), dimensionName));
        }
        boolean result = this.unforceChunkRecord(owner, chunkRecord, level);
        if (result) {
            this.forcedChunks.remove(owner);
            this.setDirty();
        }
        return result;
    }

    private synchronized boolean unforceChunkRecord(UUID owner, LoadChunkRecord chunkRecord, ServerLevel level) {
        boolean result = true;
        ChunkPos pos = chunkRecord.getPos();
        int chunkRadius = chunkRecord.getRadius();
        AdvancedPeripherals.debug(String.format("Trying to unload forced chunk cluster %s at %s with radius %d", owner, pos, chunkRadius), Level.WARN);
        for (int x = -chunkRadius; x <= chunkRadius; ++x) {
            for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                result &= ChunkManager.unforceChunk(owner, level, new ChunkPos(pos.x + x, pos.z + z));
            }
        }
        return result;
    }

    public synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        AdvancedPeripherals.debug(String.format("Schedule chunk manager init, forcedChunks = %d", this.forcedChunks.size()), Level.WARN);
        int chunkRadius = (Integer)APConfig.PERIPHERALS_CONFIG.chunkyTurtleRadius.get();
        Map<String, ServerLevel> levels = ChunkManager.getServerLevels();
        this.forcedChunks.forEach((uuid, value) -> {
            String dimensionName = value.getDimensionName();
            ServerLevel level = (ServerLevel)levels.get(dimensionName);
            if (level == null) {
                AdvancedPeripherals.debug("Skipped not exists dimension " + dimensionName, Level.ERROR);
                return;
            }
            ChunkPos pos = value.getPos();
            int loadedRadius = value.getRadius();
            AdvancedPeripherals.debug(String.format("Recorded chunk in %s at %s with radius %d", dimensionName, pos, loadedRadius), Level.INFO);
            if (loadedRadius == chunkRadius) {
                return;
            }
            if (loadedRadius == -1) {
                for (int x = -chunkRadius; x <= chunkRadius; ++x) {
                    for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                        ChunkManager.forceChunk(uuid, level, new ChunkPos(pos.x + x, pos.z + z));
                    }
                }
            } else if (loadedRadius > chunkRadius) {
                for (int x = -loadedRadius; x <= loadedRadius; ++x) {
                    for (int z = -loadedRadius; z <= loadedRadius; ++z) {
                        if (Math.abs(x) <= chunkRadius && Math.abs(z) <= chunkRadius) continue;
                        ChunkManager.unforceChunk(uuid, level, new ChunkPos(pos.x + x, pos.z + z));
                    }
                }
            } else if (loadedRadius < chunkRadius) {
                for (int x = -chunkRadius; x <= chunkRadius; ++x) {
                    for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                        if (Math.abs(x) <= loadedRadius && Math.abs(z) <= loadedRadius) continue;
                        ChunkManager.forceChunk(uuid, level, new ChunkPos(pos.x + x, pos.z + z));
                    }
                }
            }
            value.setRadius(chunkRadius);
            this.setDirty();
        });
    }

    public synchronized void cleanup() {
        AdvancedPeripherals.debug("Schedule chunk manager cleanup", Level.WARN);
        Map<String, ServerLevel> levels = ChunkManager.getServerLevels();
        Iterator<Map.Entry<UUID, LoadChunkRecord>> iterator = this.forcedChunks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, LoadChunkRecord> entry = iterator.next();
            UUID uuid = entry.getKey();
            LoadChunkRecord chunkRecord = entry.getValue();
            String dimensionName = chunkRecord.getDimensionName();
            ServerLevel level = levels.get(dimensionName);
            if (level == null || chunkRecord.isValid()) continue;
            AdvancedPeripherals.debug(String.format("Purge forced chunk for %s", uuid), Level.WARN);
            this.unforceChunkRecord(uuid, chunkRecord, level);
            iterator.remove();
            this.setDirty();
        }
    }

    @NotNull
    public synchronized CompoundTag save(@NotNull CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        AdvancedPeripherals.debug("Schedule chunk manager save, forcedChunks = " + this.forcedChunks.size(), Level.WARN);
        CompoundTag forcedChunksTag = new CompoundTag();
        this.forcedChunks.forEach((key, value) -> forcedChunksTag.put(key.toString(), (Tag)value.serialize()));
        data.put(FORCED_CHUNKS_TAG, (Tag)forcedChunksTag);
        return data;
    }

    private static Map<String, ServerLevel> getServerLevels() {
        HashMap<String, ServerLevel> levels = new HashMap<String, ServerLevel>();
        ServerLifecycleHooks.getCurrentServer().getAllLevels().forEach(level -> {
            String dimensionName = level.dimension().location().toString();
            levels.put(dimensionName, (ServerLevel)level);
        });
        return levels;
    }

    private static ServerLevel getServerLevel(String name) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)name));
        return ServerLifecycleHooks.getCurrentServer().getLevel(key);
    }

    private static class LoadChunkRecord {
        private static final String POS_TAG = "pos";
        private static final String DIMENSION_NAME_TAG = "dimensionName";
        private static final String RADIUS_TAG = "radius";
        @NotNull
        private final String dimensionName;
        @NotNull
        private final ChunkPos pos;
        private int radius;
        private long lastTouch;

        LoadChunkRecord(@NotNull String dimensionName, @NotNull ChunkPos pos, int radius) {
            this.dimensionName = dimensionName;
            this.pos = pos;
            this.radius = radius;
            this.lastTouch = tickCounter;
        }

        public static LoadChunkRecord deserialize(@NotNull CompoundTag tag) {
            Set keys = tag.getAllKeys();
            int radius = keys.contains(RADIUS_TAG) ? tag.getInt(RADIUS_TAG) : -1;
            return new LoadChunkRecord(tag.getString(DIMENSION_NAME_TAG), NBTUtil.chunkPosFromNBT(tag.getCompound(POS_TAG)), radius);
        }

        @NotNull
        public ChunkPos getPos() {
            return this.pos;
        }

        @NotNull
        public String getDimensionName() {
            return this.dimensionName;
        }

        public int getRadius() {
            return this.radius;
        }

        public void setRadius(int radius) {
            this.radius = radius;
        }

        public void touch() {
            this.lastTouch = tickCounter;
        }

        public boolean isValid() {
            return this.lastTouch + (long)((Integer)APConfig.PERIPHERALS_CONFIG.chunkLoadValidTime.get() * 20) >= tickCounter;
        }

        @NotNull
        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.putString(DIMENSION_NAME_TAG, this.dimensionName);
            tag.put(POS_TAG, (Tag)NBTUtil.toNBT(this.pos));
            tag.putInt(RADIUS_TAG, this.radius);
            return tag;
        }
    }
}

