/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.refinedstorage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RSApi;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemItemHandler;
import de.srendi.advancedperipherals.common.util.inventory.ItemFilter;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RSItemHandler
implements IStorageSystemItemHandler {
    @NotNull
    private final Network network;
    private final StorageNetworkComponent component;

    public RSItemHandler(@NotNull Network network) {
        this.network = network;
        this.component = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        long insertedAmount = this.component.insert((ResourceKey)ItemResource.ofItemStack((ItemStack)stack), (long)stack.getCount(), simulate ? Action.SIMULATE : Action.EXECUTE, Actor.EMPTY);
        ItemStack remain = stack.copyWithCount((int)((long)stack.getCount() - insertedAmount));
        return remain;
    }

    @Override
    public ItemStack extractItem(ItemFilter filter, int count, boolean simulate) {
        AdvancedPeripherals.debug("Trying to extract item from filter: " + String.valueOf(filter));
        ItemResource itemResource = RSApi.getItem(this.network, filter);
        if (itemResource == null) {
            return ItemStack.EMPTY;
        }
        long extractedAmount = this.component.extract((ResourceKey)itemResource, (long)count, simulate ? Action.SIMULATE : Action.EXECUTE, Actor.EMPTY);
        ItemStack extracted = itemResource.toItemStack(extractedAmount);
        AdvancedPeripherals.debug("Extracted item: " + String.valueOf(extracted) + " from filter: " + String.valueOf(filter));
        return extracted;
    }
}

