/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.owner;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.IOwnerAbility;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.common.setup.DataComponents;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralPlugin;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import org.jetbrains.annotations.NotNull;

public abstract class FuelAbility<T extends IPeripheralOwner>
implements IOwnerAbility,
IPeripheralPlugin {
    protected static final int DEFAULT_FUEL_CONSUMING_RATE = 1;
    @NotNull
    protected T owner;

    public FuelAbility(@NotNull T owner) {
        this.owner = owner;
    }

    protected abstract boolean consumeFuel(int var1);

    protected abstract int getMaxFuelConsumptionRate();

    protected int getConsumptionRate() {
        int rate;
        DataComponentPatch settings = this.owner.getDataStorage();
        Optional opt = settings.get((DataComponentType)DataComponents.FUEL_CONSUMPTION_RATE.get());
        int n = rate = opt != null && opt.isPresent() ? (Integer)opt.get() : 0;
        if (rate == 0) {
            this.setConsumptionRate(1);
            return 1;
        }
        return rate;
    }

    protected void setConsumptionRate(int rate) {
        int maxFuelRate;
        if (rate < 1) {
            rate = 1;
        }
        if (rate > (maxFuelRate = this.getMaxFuelConsumptionRate())) {
            rate = maxFuelRate;
        }
        PatchedDataComponentMap settings = PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)this.owner.getDataStorage());
        settings.set((DataComponentType)DataComponents.FUEL_CONSUMPTION_RATE.get(), (Object)rate);
    }

    public abstract boolean isFuelConsumptionDisable();

    public abstract int getFuelCount();

    public abstract int getFuelMaxCount();

    public abstract void addFuel(int var1);

    public int getFuelConsumptionMultiply() {
        return (int)Math.pow(2.0, (float)this.getConsumptionRate() - 1.0f);
    }

    public int reduceCooldownAccordingToConsumptionRate(int cooldown) {
        return cooldown / this.getConsumptionRate();
    }

    public boolean consumeFuel(int count, boolean simulate) {
        if (this.isFuelConsumptionDisable()) {
            return true;
        }
        int realCount = count * this.getFuelConsumptionMultiply();
        if (simulate) {
            return this.getFuelLevel() >= realCount;
        }
        return this.consumeFuel(realCount);
    }

    @LuaFunction(mainThread=true)
    public final int getFuelLevel() {
        return this.getFuelCount();
    }

    @LuaFunction(mainThread=true)
    public final int getMaxFuelLevel() {
        return this.getFuelMaxCount();
    }

    @LuaFunction(mainThread=true)
    public final int getFuelConsumptionRate() {
        return this.getConsumptionRate();
    }

    @LuaFunction(mainThread=true)
    public final MethodResult setFuelConsumptionRate(int rate) {
        if (rate < 1) {
            return MethodResult.of((Object[])new Object[]{null, "Too small fuel consumption rate"});
        }
        if (rate > this.getMaxFuelConsumptionRate()) {
            return MethodResult.of((Object[])new Object[]{null, "Too big fuel consumption rate"});
        }
        this.setConsumptionRate(rate);
        return MethodResult.of((Object)true);
    }

    @Override
    public void collectConfiguration(Map<String, Object> dict) {
        dict.put("maxFuelConsumptionRate", this.getMaxFuelConsumptionRate());
    }
}

