/*
 * Decompiled with CFR 0.152.
 */
package com.weido.create_bb.mixin;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.bogey.StandardBogeyBlock;
import com.simibubi.create.content.trains.bogey.StandardBogeyBlockEntity;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.weido.create_bb.data.BogieFunctionality;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={StandardBogeyBlock.class})
public abstract class StandardBogeyBlockMixin
extends AbstractBogeyBlock<StandardBogeyBlockEntity>
implements IBE<StandardBogeyBlockEntity>,
ProperWaterloggedBlock,
SpecialBlockItemRequirement {
    public StandardBogeyBlockMixin(BlockBehaviour.Properties properties, BogeySizes.BogeySize size) {
        super(properties, size);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected ItemInteractionResult onInteractWithBogey(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return BogieFunctionality.BogeyMenuInteraction(level, pos, player, hand);
    }

    public TrackMaterial.TrackType getTrackType(BogeyStyle style) {
        return TrackMaterial.TrackType.STANDARD;
    }

    public double getWheelPointSpacing() {
        return 2.0;
    }

    public double getWheelRadius() {
        return (this.size == BogeySizes.LARGE ? 12.5 : 6.5) / 16.0;
    }

    public Vec3 getConnectorAnchorOffset() {
        return new Vec3(0.0, 0.21875, 1.0);
    }

    public BogeyStyle getDefaultStyle() {
        return AllBogeyStyles.STANDARD;
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Player player) {
        return AllBlocks.RAILWAY_CASING.asStack();
    }

    public Class<StandardBogeyBlockEntity> getBlockEntityClass() {
        return StandardBogeyBlockEntity.class;
    }

    public BlockEntityType<? extends StandardBogeyBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.BOGEY.get();
    }
}

