/*
 * Decompiled with CFR 0.152.
 */
package com.weido.create_bb.data.menu.Input;

import com.simibubi.create.foundation.gui.widget.ScrollInput;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class AxleCountScrollInput
extends ScrollInput {
    private final MutableComponent scrollToSelect = Component.translatable((String)"create_bb.menu.scroll_selection");
    private final MutableComponent noOptionAvailable = Component.translatable((String)"create_bb.menu.no_options_available");
    private int minAxles = 1;
    private int maxAxles = 6;

    public AxleCountScrollInput(int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
        this.withRange(this.minAxles, this.maxAxles + 1).titled(Component.translatable((String)"create_bb.menu.axle_count")).format(index -> index > this.maxAxles ? Component.empty() : Component.literal((String)String.valueOf(index))).inverted().setState(2);
        this.updateTooltip();
    }

    public void updateOptions(int min, int max) {
        this.minAxles = min;
        this.maxAxles = max;
        this.withRange(this.minAxles, this.maxAxles + 1);
        if (this.state > this.maxAxles) {
            this.setState(this.maxAxles);
        } else if (this.state < this.minAxles) {
            this.setState(this.minAxles);
        }
        this.format(index -> index > this.maxAxles ? Component.empty() : Component.literal((String)String.valueOf(index)));
        this.updateTooltip();
    }

    public int getMinAxles() {
        return this.minAxles;
    }

    public int getMaxAxles() {
        return this.maxAxles;
    }

    protected void updateTooltip() {
        this.toolTip.clear();
        if (this.title != null) {
            this.toolTip.add(this.title.copy().withStyle(s -> s.withColor(HEADER_RGB.getRGB())));
        }
        if (this.minAxles == this.maxAxles) {
            this.toolTip.add(this.noOptionAvailable.plainCopy().withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        } else {
            for (int i = this.minAxles; i <= this.maxAxles; ++i) {
                MutableComponent axleCount = Component.empty().append(i == this.state ? "-> " : "> ").append(String.valueOf(i));
                this.toolTip.add(axleCount.withStyle(i == this.state ? ChatFormatting.WHITE : ChatFormatting.GRAY));
            }
            this.toolTip.add(this.scrollToSelect.plainCopy().withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
    }
}

