/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.vat.base;

import com.drmangotea.tfmg.base.lang.TFMGLang;
import com.drmangotea.tfmg.content.machinery.vat.base.VatBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.DeferredSoundType;

public class VatBlock
extends Block
implements IWrenchable,
IBE<VatBlockEntity> {
    public final String vatType;
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.create((String)"bottom");
    public static final EnumProperty<Shape> SHAPE = EnumProperty.create((String)"shape", Shape.class);
    static final VoxelShape CAMPFIRE_SMOKE_CLIP = Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final SoundType SILENCED_METAL = new DeferredSoundType(0.1f, 1.5f, () -> SoundEvents.METAL_BREAK, () -> SoundEvents.METAL_STEP, () -> SoundEvents.METAL_PLACE, () -> SoundEvents.METAL_HIT, () -> SoundEvents.METAL_FALL);

    public static VatBlock steel(BlockBehaviour.Properties properties) {
        return new VatBlock(properties, "tfmg:steel_vat");
    }

    public static VatBlock cast_iron(BlockBehaviour.Properties properties) {
        return new VatBlock(properties, "tfmg:cast_iron_vat");
    }

    public static VatBlock fireproof(BlockBehaviour.Properties properties) {
        return new VatBlock(properties, "tfmg:firebrick_lined_vat");
    }

    public VatBlock(BlockBehaviour.Properties properties, String vatType) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TOP, (Comparable)Boolean.valueOf(true))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).setValue(SHAPE, (Comparable)((Object)Shape.PLAIN)));
        this.vatType = vatType;
    }

    public static boolean isVat(BlockState state) {
        return state.getBlock() instanceof VatBlock;
    }

    public static void updateVatState(BlockState pState, Level pLevel, BlockPos tankPos) {
        BlockState tankState = pLevel.getBlockState(tankPos);
        Block block = tankState.getBlock();
        if (!(block instanceof VatBlock)) {
            return;
        }
        VatBlock tank = (VatBlock)block;
        VatBlockEntity vatBE = (VatBlockEntity)tank.getBlockEntity((BlockGetter)pLevel, tankPos);
        if (vatBE == null) {
            return;
        }
        vatBE.evaluateNextTick = true;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        if (oldState.getBlock() == state.getBlock()) {
            return;
        }
        if (moved) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, VatBlockEntity::updateConnectivity);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.add(new Property[]{TOP, BOTTOM, SHAPE});
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        VatBlockEntity vatAt = (VatBlockEntity)ConnectivityHandler.partAt(this.getBlockEntityType(), (BlockGetter)world, (BlockPos)pos);
        if (vatAt == null) {
            return 0;
        }
        VatBlockEntity controllerTE = vatAt.getControllerBE();
        if (controllerTE == null || !controllerTE.window) {
            return 0;
        }
        return vatAt.luminosity;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        this.withBlockEntityDo((BlockGetter)context.getLevel(), context.getClickedPos(), VatBlockEntity::toggleWindows);
        return InteractionResult.SUCCESS;
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pContext == CollisionContext.empty()) {
            return CAMPFIRE_SMOKE_CLIP;
        }
        return pState.getShape(pLevel, pPos);
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.block();
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasBlockEntity() && (state.getBlock() != newState.getBlock() || !newState.hasBlockEntity())) {
            BlockEntity be = world.getBlockEntity(pos);
            if (!(be instanceof VatBlockEntity)) {
                return;
            }
            VatBlockEntity tankBE = (VatBlockEntity)be;
            world.removeBlockEntity(pos);
            ConnectivityHandler.splitMulti((BlockEntity)tankBE);
        }
    }

    public Class<VatBlockEntity> getBlockEntityClass() {
        return VatBlockEntity.class;
    }

    public BlockEntityType<? extends VatBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.CHEMICAL_VAT.get();
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        boolean x = mirror == Mirror.FRONT_BACK;
        switch (((Shape)((Object)state.getValue(SHAPE))).ordinal()) {
            case 4: {
                return (BlockState)state.setValue(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_NW : Shape.WINDOW_SE)));
            }
            case 2: {
                return (BlockState)state.setValue(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_NE : Shape.WINDOW_SW)));
            }
            case 5: {
                return (BlockState)state.setValue(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_SW : Shape.WINDOW_NE)));
            }
            case 3: {
                return (BlockState)state.setValue(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_SE : Shape.WINDOW_NW)));
            }
        }
        return state;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        for (int i = 0; i < rotation.ordinal(); ++i) {
            state = this.rotateOnce(state);
        }
        return state;
    }

    private BlockState rotateOnce(BlockState state) {
        switch (((Shape)((Object)state.getValue(SHAPE))).ordinal()) {
            case 4: {
                return (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.WINDOW_SE));
            }
            case 2: {
                return (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.WINDOW_NE));
            }
            case 5: {
                return (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.WINDOW_SW));
            }
            case 3: {
                return (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.WINDOW_NW));
            }
        }
        return state;
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        SoundType soundType = super.getSoundType(state, world, pos, entity);
        if (entity != null && entity.getPersistentData().contains("SilenceTankSound")) {
            return SILENCED_METAL;
        }
        return soundType;
    }

    public static enum Shape implements StringRepresentable
    {
        PLAIN,
        WINDOW,
        WINDOW_NW,
        WINDOW_SW,
        WINDOW_NE,
        WINDOW_SE;


        public String getSerializedName() {
            return TFMGLang.asId((String)this.name());
        }
    }
}

