/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.winding_machine;

import com.drmangotea.tfmg.base.TFMGShapes;
import com.drmangotea.tfmg.content.machinery.misc.winding_machine.SpoolItem;
import com.drmangotea.tfmg.content.machinery.misc.winding_machine.WindingMachineBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WindingMachineBlock
extends HorizontalKineticBlock
implements IBE<WindingMachineBlockEntity> {
    public static final BooleanProperty POWERED = BooleanProperty.create((String)"powered");

    public WindingMachineBlock(BlockBehaviour.Properties p_54120_) {
        super(p_54120_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getCounterClockWise().getAxis();
    }

    public boolean isSignalSource(BlockState p_60571_) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
    }

    public int getSignal(BlockState p_60483_, BlockGetter p_60484_, BlockPos p_60485_, Direction p_60486_) {
        return (Boolean)p_60483_.getValue((Property)POWERED) != false ? 15 : 0;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        IBE.onRemove((BlockState)pState, (Level)pLevel, (BlockPos)pPos, (BlockState)pNewState);
    }

    public VoxelShape getShape(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return TFMGShapes.WINDING_MACHINE.get((Direction)p_60555_.getValue(HORIZONTAL_FACING));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof WindingMachineBlockEntity) {
            WindingMachineBlockEntity be = (WindingMachineBlockEntity)blockEntity;
            if (player.getItemInHand(hand).isEmpty()) {
                if (!be.inventory.isEmpty() && !(be.inventory.getItem(0).getItem() instanceof SpoolItem) && player.isShiftKeyDown()) {
                    player.setItemInHand(hand, be.inventory.getStackInSlot(0));
                    be.inventory.setItem(0, ItemStack.EMPTY);
                    return ItemInteractionResult.SUCCESS;
                }
                if (!be.spool.isEmpty()) {
                    player.setItemInHand(hand, be.spool);
                    be.spool = ItemStack.EMPTY;
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (be.inventory.isEmpty() && !(player.getItemInHand(hand).getItem() instanceof SpoolItem)) {
                ItemStack stack1 = player.getItemInHand(hand).copy();
                stack1.setCount(1);
                be.inventory.setItem(0, stack1);
                player.getItemInHand(hand).shrink(1);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == ((Direction)state.getValue(HORIZONTAL_FACING)).getCounterClockWise();
    }

    public Class<WindingMachineBlockEntity> getBlockEntityClass() {
        return WindingMachineBlockEntity.class;
    }

    public BlockEntityType<? extends WindingMachineBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.WINDING_MACHINE.get();
    }
}

